/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponse;
import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.Response;
import com.google.api.services.sheets.v4.model.SheetProperties;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import eu.easyrpa.openframework.google.sheets.Row;
import eu.easyrpa.openframework.google.sheets.Sheet;
import eu.easyrpa.openframework.google.sheets.constants.MatchMethod;
import eu.easyrpa.openframework.google.sheets.exceptions.SpreadsheetException;
import eu.easyrpa.openframework.google.sheets.internal.SpreadsheetUpdateRequestsBatch;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SpreadsheetDocument
implements Iterable<Sheet> {
    private Sheets sheetsService;
    private Spreadsheet spreadsheet;
    private int activeSheetIndex;
    private SpreadsheetUpdateRequestsBatch updateRequestsBatch;

    public SpreadsheetDocument(Sheets sheetsService, String spreadsheetId) {
        this.sheetsService = sheetsService;
        try {
            this.spreadsheet = (Spreadsheet)sheetsService.spreadsheets().get(spreadsheetId).setIncludeGridData(Boolean.valueOf(true)).execute();
            this.activeSheetIndex = 0;
        }
        catch (IOException e) {
            throw new SpreadsheetException(String.format("Getting of spreadsheet with ID '%s' from Google Drive has failed.", spreadsheetId), e);
        }
    }

    public String getId() {
        return this.spreadsheet.getSpreadsheetId();
    }

    public String getName() {
        return this.spreadsheet.getProperties().getTitle();
    }

    public void rename(String name) {
        if (name != null && !name.equals(this.spreadsheet.getProperties().getTitle())) {
            this.spreadsheet.getProperties().setTitle(name);
            this.batchUpdate(request -> request.addUpdateSpreadsheetPropertiesRequest(this.spreadsheet, "Title"));
        }
    }

    public InputStream exportAsXLSX() {
        try {
            GenericUrl url = new GenericUrl(this.spreadsheet.getSpreadsheetUrl().replace("edit", "export?format=xlsx"));
            HttpResponse response = this.sheetsService.getRequestFactory().buildGetRequest(url).execute();
            return response.getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getSheetNames() {
        return this.spreadsheet.getSheets().stream().map(sheet -> sheet.getProperties().getTitle()).collect(Collectors.toList());
    }

    public Sheet createSheet(String sheetName) {
        Optional<com.google.api.services.sheets.v4.model.Sheet> sheet = this.spreadsheet.getSheets().stream().filter(s -> s.getProperties().getTitle().equals(sheetName)).findFirst();
        if (sheet.isPresent()) {
            this.activeSheetIndex = sheet.get().getProperties().getIndex();
        } else {
            this.activeSheetIndex = this.spreadsheet.getSheets().size();
            com.google.api.services.sheets.v4.model.Sheet newSheet = new com.google.api.services.sheets.v4.model.Sheet();
            newSheet.setProperties(new SheetProperties().setIndex(Integer.valueOf(this.activeSheetIndex)).setTitle(sheetName));
            this.spreadsheet.getSheets().add(newSheet);
            SpreadsheetUpdateRequestsBatch request = new SpreadsheetUpdateRequestsBatch(this);
            request.addNewSheetRequest(newSheet);
            BatchUpdateSpreadsheetResponse response = request.send().get(0);
            newSheet.setProperties(((Response)response.getReplies().get(0)).getAddSheet().getProperties());
        }
        return new Sheet(this, this.activeSheetIndex);
    }

    public void removeSheet(String sheetName) {
        Optional<com.google.api.services.sheets.v4.model.Sheet> sheet = this.spreadsheet.getSheets().stream().filter(s -> s.getProperties().getTitle().equals(sheetName)).findFirst();
        if (sheet.isPresent()) {
            this.spreadsheet.getSheets().remove(sheet.get());
            this.batchUpdate(request -> request.addDeleteSheetRequest(((com.google.api.services.sheets.v4.model.Sheet)sheet.get()).getProperties().getSheetId()));
        }
    }

    public void removeSheet(Sheet sheet) {
        if (sheet.getDocument() == this) {
            this.spreadsheet.getSheets().remove(sheet.getIndex());
            this.batchUpdate(request -> request.addDeleteSheetRequest(sheet.getId()));
        }
    }

    public Sheet getActiveSheet() {
        return new Sheet(this, this.activeSheetIndex);
    }

    public Sheet selectSheet(int index) {
        if (index >= 0 && index < this.spreadsheet.getSheets().size()) {
            this.activeSheetIndex = index;
            return new Sheet(this, this.activeSheetIndex);
        }
        return null;
    }

    public Sheet selectSheet(String sheetName) {
        Optional<com.google.api.services.sheets.v4.model.Sheet> sheet = this.spreadsheet.getSheets().stream().filter(s -> s.getProperties().getTitle().equals(sheetName)).findFirst();
        if (sheet.isPresent()) {
            this.activeSheetIndex = sheet.get().getProperties().getIndex();
            return new Sheet(this, this.activeSheetIndex);
        }
        return null;
    }

    public Sheet findSheet(String ... values) {
        return this.findSheet(MatchMethod.EXACT, values);
    }

    public Sheet findSheet(MatchMethod matchMethod, String ... values) {
        int sheetIndex = 0;
        for (Sheet sheet : this) {
            Row row = sheet.findRow(matchMethod, values);
            if (row != null) {
                this.activeSheetIndex = sheetIndex;
                return sheet;
            }
            ++sheetIndex;
        }
        return null;
    }

    public Spreadsheet getGSpreadsheet() {
        return this.spreadsheet;
    }

    public Sheets getSheetsService() {
        return this.sheetsService;
    }

    public void reload() {
        try {
            this.spreadsheet = (Spreadsheet)this.sheetsService.spreadsheets().get(this.spreadsheet.getSpreadsheetId()).setIncludeGridData(Boolean.valueOf(true)).execute();
        }
        catch (IOException e) {
            throw new SpreadsheetException(String.format("Getting of spreadsheet with ID '%s' from Google Drive has failed.", this.spreadsheet.getSpreadsheetId()), e);
        }
    }

    @Override
    public Iterator<Sheet> iterator() {
        return new SheetIterator(this.spreadsheet.getSheets().size());
    }

    public void setAutoCommit(boolean isAutoCommit) {
        if (isAutoCommit) {
            this.commit();
        } else if (this.updateRequestsBatch == null) {
            this.updateRequestsBatch = new SpreadsheetUpdateRequestsBatch(this);
        }
    }

    public void commit() {
        if (this.updateRequestsBatch != null) {
            this.updateRequestsBatch.send();
            this.reload();
            this.updateRequestsBatch = new SpreadsheetUpdateRequestsBatch(this);
        }
    }

    public void withOneBatch(Consumer<SpreadsheetDocument> action) {
        boolean isRequestsBatchCreatedHere = false;
        if (this.updateRequestsBatch == null) {
            this.updateRequestsBatch = new SpreadsheetUpdateRequestsBatch(this);
            isRequestsBatchCreatedHere = true;
        }
        action.accept(this);
        if (isRequestsBatchCreatedHere) {
            this.updateRequestsBatch.send();
            this.updateRequestsBatch = null;
            this.reload();
        }
    }

    protected void batchUpdate(Consumer<SpreadsheetUpdateRequestsBatch> action) {
        this.withOneBatch(doc -> action.accept(this.updateRequestsBatch));
    }

    private class SheetIterator
    implements Iterator<Sheet> {
        private int index = 0;
        private int sheetsCount;

        public SheetIterator(int sheetsCount) {
            this.sheetsCount = sheetsCount;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.sheetsCount;
        }

        @Override
        public Sheet next() {
            return new Sheet(SpreadsheetDocument.this, this.index++);
        }
    }
}

