/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.model.BatchUpdateSpreadsheetResponse;
import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.CopySheetToAnotherSpreadsheetRequest;
import com.google.api.services.sheets.v4.model.DimensionProperties;
import com.google.api.services.sheets.v4.model.GridData;
import com.google.api.services.sheets.v4.model.GridRange;
import com.google.api.services.sheets.v4.model.Response;
import com.google.api.services.sheets.v4.model.RowData;
import com.google.api.services.sheets.v4.model.SheetProperties;
import eu.easyrpa.openframework.google.sheets.Cell;
import eu.easyrpa.openframework.google.sheets.CellRange;
import eu.easyrpa.openframework.google.sheets.CellRef;
import eu.easyrpa.openframework.google.sheets.Column;
import eu.easyrpa.openframework.google.sheets.Row;
import eu.easyrpa.openframework.google.sheets.SpreadsheetDocument;
import eu.easyrpa.openframework.google.sheets.Table;
import eu.easyrpa.openframework.google.sheets.constants.InsertMethod;
import eu.easyrpa.openframework.google.sheets.constants.MatchMethod;
import eu.easyrpa.openframework.google.sheets.internal.SpreadsheetUpdateRequestsBatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class Sheet
implements Iterable<Row> {
    private SpreadsheetDocument parent;
    private int sheetIndex;

    public Sheet(SpreadsheetDocument parent, int sheetIndex) {
        this.sheetIndex = sheetIndex;
        this.parent = parent;
    }

    public SpreadsheetDocument getDocument() {
        return this.parent;
    }

    public int getIndex() {
        return this.sheetIndex;
    }

    public String getName() {
        return this.getGSheet().getProperties().getTitle();
    }

    public int getId() {
        return this.getGSheet().getProperties().getSheetId();
    }

    public Cell getCell(String cellRef) {
        CellRef ref = new CellRef(cellRef);
        return this.getCell(ref.getRow(), ref.getCol());
    }

    public Cell getCell(int rowIndex, int colIndex) {
        Row row = this.getRow(rowIndex);
        return row != null ? row.getCell(colIndex) : null;
    }

    public Cell findCell(String value) {
        return this.findCell(MatchMethod.EXACT, value);
    }

    public Cell findCell(MatchMethod matchMethod, String value) {
        if (matchMethod == null) {
            matchMethod = MatchMethod.EXACT;
        }
        for (Row row : this) {
            for (Cell cell : row) {
                if (!matchMethod.match(cell.getValue(String.class), value)) continue;
                return cell;
            }
        }
        return null;
    }

    public Object getValue(String cellRef) {
        CellRef ref = new CellRef(cellRef);
        return this.getValue(ref.getRow(), ref.getCol(), Object.class);
    }

    public <T> T getValue(String cellRef, Class<T> valueType) {
        CellRef ref = new CellRef(cellRef);
        return this.getValue(ref.getRow(), ref.getCol(), valueType);
    }

    public Object getValue(int rowIndex, int colIndex) {
        return this.getValue(rowIndex, colIndex, Object.class);
    }

    public <T> T getValue(int rowIndex, int colIndex, Class<T> valueType) {
        Cell cell = this.getCell(rowIndex, colIndex);
        return cell != null ? (T)cell.getValue(valueType) : null;
    }

    public void setValue(String cellRef, Object value) {
        CellRef ref = new CellRef(cellRef);
        this.setValue(ref.getRow(), ref.getCol(), value);
    }

    public void setValue(int rowIndex, int colIndex, Object value) {
        if (rowIndex >= 0 && colIndex >= 0) {
            int rowsAmountToAppend = rowIndex + 1 - this.getMaxRowsCount();
            this.parent.batchUpdate(r -> {
                Row row;
                if (rowsAmountToAppend > 0) {
                    this.appendRowsMetadata(rowsAmountToAppend);
                    r.addAppendRowsRequest(rowsAmountToAppend, this.getId());
                }
                if ((row = this.getRow(rowIndex)) == null) {
                    row = this.createRow(rowIndex);
                }
                row.setValue(colIndex, value);
            });
        }
    }

    public List<List<Object>> getValues() {
        return this.getRange(this.getFirstRowIndex(), this.getFirstColumnIndex(), this.getLastRowIndex(), this.getLastColumnIndex());
    }

    public void setValues(List<?> values) {
        this.putRange(0, 0, values);
    }

    public List<List<Object>> getRange(String startRef, String endRef) {
        return this.getRange(startRef, endRef, Object.class);
    }

    public <T> List<List<T>> getRange(String startRef, String endRef, Class<T> valueType) {
        CellRef sRef = new CellRef(startRef);
        CellRef eRef = new CellRef(endRef);
        return this.getRange(sRef.getRow(), sRef.getCol(), eRef.getRow(), eRef.getCol(), valueType);
    }

    public List<List<Object>> getRange(int startRow, int startCol, int endRow, int endCol) {
        return this.getRange(startRow, startCol, endRow, endCol, Object.class);
    }

    public <T> List<List<T>> getRange(int startRow, int startCol, int endRow, int endCol, Class<T> valueType) {
        ArrayList<List<T>> data = new ArrayList<List<T>>();
        if (startRow < 0 || startCol < 0 || endRow < 0 || endCol < 0) {
            return data;
        }
        int r1 = Math.min(startRow, endRow);
        int r2 = Math.max(startRow, endRow);
        int c1 = Math.min(startCol, endCol);
        int c2 = Math.max(startCol, endCol);
        for (int row = r1; row <= r2; ++row) {
            ArrayList<T> rowList = new ArrayList<T>();
            for (int col = c1; col <= c2; ++col) {
                rowList.add(this.getValue(row, col, valueType));
            }
            data.add(rowList);
        }
        return data;
    }

    public void putRange(String startRef, List<?> values) {
        CellRef sRef = new CellRef(startRef);
        this.putRange(sRef.getRow(), sRef.getCol(), values);
    }

    public void putRange(int startRow, int startCol, List<?> values) {
        if (values != null && values.size() > 0) {
            List<Object> data = values.get(0) instanceof List ? values : Collections.singletonList(values);
            int rowsAmountToAppend = startRow + values.size() - this.getMaxRowsCount();
            this.parent.batchUpdate(r -> {
                if (rowsAmountToAppend > 0) {
                    this.appendRowsMetadata(rowsAmountToAppend);
                    r.addAppendRowsRequest(rowsAmountToAppend, this.getId());
                }
                int rowIndex = startRow;
                for (Object rowList : data) {
                    if (!(rowList instanceof List)) continue;
                    Row row = this.getRow(rowIndex);
                    if (row == null) {
                        row = this.createRow(rowIndex);
                    }
                    row.putRange(startCol, (List)rowList);
                    ++rowIndex;
                }
            });
        }
    }

    public Cell mergeCells(String regionRef) {
        CellRange region = new CellRange(regionRef);
        return this.mergeCells(region.getFirstRow(), region.getFirstCol(), region.getLastRow(), region.getLastCol());
    }

    public Cell mergeCells(CellRange region) {
        return this.mergeCells(region.getFirstRow(), region.getFirstCol(), region.getLastRow(), region.getLastCol());
    }

    public Cell mergeCells(String startCellRef, String endCellRef) {
        CellRef startRef = new CellRef(startCellRef);
        CellRef endRef = new CellRef(endCellRef);
        return this.mergeCells(startRef.getRow(), startRef.getCol(), endRef.getRow(), endRef.getCol());
    }

    public Cell mergeCells(int startRow, int startCol, int endRow, int endCol) {
        com.google.api.services.sheets.v4.model.Sheet gSheet = this.getGSheet();
        GridRange regionToMerge = new GridRange().setSheetId(gSheet.getProperties().getSheetId()).setStartRowIndex(Integer.valueOf(startRow)).setStartColumnIndex(Integer.valueOf(startCol)).setEndRowIndex(Integer.valueOf(endRow + 1)).setEndColumnIndex(Integer.valueOf(endCol + 1));
        this.parent.batchUpdate(r -> {
            this.unmergeCells(startRow, startCol, endRow, endCol);
            r.addMergeCellsRequest(regionToMerge);
        });
        ArrayList<GridRange> mergedRegions = gSheet.getMerges();
        if (mergedRegions == null) {
            mergedRegions = new ArrayList<GridRange>();
            gSheet.setMerges(mergedRegions);
        }
        mergedRegions.add(regionToMerge);
        return new Cell(this, startRow, startCol);
    }

    public void unmergeCells(String rangeRef) {
        CellRange region = new CellRange(rangeRef);
        this.unmergeCells(region.getFirstRow(), region.getFirstCol(), region.getLastRow(), region.getLastCol());
    }

    public void unmergeCells(CellRange range) {
        this.unmergeCells(range.getFirstRow(), range.getFirstCol(), range.getLastRow(), range.getLastCol());
    }

    public void unmergeCells(String startCellRef, String endCellRef) {
        CellRef startRef = new CellRef(startCellRef);
        CellRef endRef = new CellRef(endCellRef);
        this.unmergeCells(startRef.getRow(), startRef.getCol(), endRef.getRow(), endRef.getCol());
    }

    public void unmergeCells(int startRow, int startCol, int endRow, int endCol) {
        com.google.api.services.sheets.v4.model.Sheet gSheet = this.getGSheet();
        if (gSheet.getMerges() == null) {
            return;
        }
        CellRange givenRegion = new CellRange(startRow, endRow, startCol, endCol);
        List mergedRegions = gSheet.getMerges().stream().map(CellRange::new).collect(Collectors.toList());
        ArrayList regionsToRemove = new ArrayList();
        for (int index = 0; index < mergedRegions.size(); ++index) {
            if (!((CellRange)mergedRegions.get(index)).intersects(givenRegion)) continue;
            regionsToRemove.add(gSheet.getMerges().get(index));
        }
        if (regionsToRemove.size() > 0) {
            this.parent.batchUpdate(r -> {
                for (GridRange region : regionsToRemove) {
                    r.addUnmergeCellsRequest(region);
                    gSheet.getMerges().remove(region);
                }
            });
        }
    }

    public List<CellRange> getMergedRegions() {
        com.google.api.services.sheets.v4.model.Sheet gSheet = this.getGSheet();
        if (gSheet.getMerges() == null) {
            return new ArrayList<CellRange>();
        }
        return gSheet.getMerges().stream().map(CellRange::new).collect(Collectors.toList());
    }

    public Row getRow(String rowRef) {
        return this.getRow(new CellRef(rowRef).getRow());
    }

    public Row getRow(int rowIndex) {
        if (rowIndex >= 0) {
            List gridsData = this.getGSheet().getData();
            if (gridsData == null) {
                return null;
            }
            for (GridData gridData : gridsData) {
                int startRow;
                List rowsData = gridData.getRowData();
                int n = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                if (rowsData == null || rowIndex < startRow || rowIndex >= startRow + rowsData.size()) continue;
                RowData row = (RowData)rowsData.get(rowIndex - startRow);
                return row != null ? new Row(this, rowIndex) : null;
            }
        }
        return null;
    }

    public Row findRow(String ... values) {
        return this.findRow(MatchMethod.EXACT, values);
    }

    public Row findRow(MatchMethod matchMethod, String ... values) {
        if (matchMethod == null) {
            matchMethod = MatchMethod.EXACT;
        }
        for (Row row : this) {
            boolean matchesFound = false;
            for (String key : values) {
                Cell cell;
                matchesFound = false;
                Iterator<Cell> iterator = row.iterator();
                while (iterator.hasNext() && !(matchesFound = matchMethod.match((cell = iterator.next()).getValue(String.class), key))) {
                }
                if (!matchesFound) break;
            }
            if (!matchesFound) continue;
            return row;
        }
        return null;
    }

    public Row createRow(int rowIndex) {
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row index can not be negative.");
        }
        List<GridData> gridsData = this.getGSheetGridsData();
        int lastRowIndex = this.getLastRowIndex();
        if (rowIndex > lastRowIndex) {
            GridData lastGridData = gridsData.get(gridsData.size() - 1);
            ArrayList<RowData> rowsData = lastGridData.getRowData();
            if (rowsData == null || rowsData.isEmpty()) {
                rowsData = new ArrayList<RowData>();
                rowsData.add(new RowData());
                lastGridData.setRowData(rowsData);
                lastGridData.setStartRow(Integer.valueOf(rowIndex));
            } else {
                for (int i = lastRowIndex + 1; i <= rowIndex; ++i) {
                    rowsData.add(new RowData());
                }
            }
        } else {
            for (int gridIndex = 0; gridIndex < gridsData.size(); ++gridIndex) {
                int startRow;
                GridData gridData = gridsData.get(gridIndex);
                int n = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                if (rowIndex < startRow) {
                    GridData newGrid = new GridData();
                    newGrid.setStartRow(Integer.valueOf(rowIndex));
                    newGrid.setRowData(new ArrayList());
                    newGrid.getRowData().add(new RowData());
                    gridsData.add(gridIndex, newGrid);
                } else {
                    if (rowIndex != startRow + gridData.getRowData().size()) continue;
                    gridData.getRowData().add(new RowData());
                }
                break;
            }
        }
        return new Row(this, rowIndex);
    }

    public void insertRows(InsertMethod method, String startCellRef, List<?> values) {
        CellRef ref = new CellRef(startCellRef);
        this.insertRows(method, ref.getRow(), ref.getCol(), values);
    }

    public void insertRows(InsertMethod method, int rowPos, int startCol, List<?> values) {
        int rowIndex;
        if (rowPos < 0 || startCol < 0 || values == null || values.isEmpty()) {
            return;
        }
        int n = rowIndex = method == null || method == InsertMethod.BEFORE ? rowPos : rowPos + 1;
        if (rowIndex > this.getLastRowIndex()) {
            this.putRange(rowIndex, startCol, values);
        } else {
            List<Object> data = values.get(0) instanceof List ? values : Collections.singletonList(values);
            int rowsCount = data.size();
            List<GridData> gridsData = this.getGSheetGridsData();
            for (int gridIndex = 0; gridIndex < gridsData.size(); ++gridIndex) {
                int startRow;
                GridData gridData = gridsData.get(gridIndex);
                int n2 = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                if (rowIndex < startRow) {
                    GridData newGrid = new GridData();
                    newGrid.setStartRow(Integer.valueOf(rowIndex));
                    newGrid.setRowData(new ArrayList());
                    for (int i = rowsCount; i > 0; --i) {
                        newGrid.getRowData().add(new RowData());
                    }
                    gridsData.add(gridIndex, newGrid);
                    break;
                }
                if (rowIndex < startRow + gridData.getRowData().size()) {
                    for (int i = rowIndex - startRow; i < rowIndex - startRow + rowsCount; ++i) {
                        gridData.getRowData().add(i, new RowData());
                    }
                } else {
                    if (rowIndex != startRow + gridData.getRowData().size()) continue;
                    for (int i = rowsCount; i > 0; --i) {
                        gridData.getRowData().add(new RowData());
                    }
                }
                break;
            }
            this.parent.batchUpdate(r -> {
                r.addInsertRowsRequest(rowIndex, rowsCount, this.getId());
                this.putRange(rowIndex, startCol, data);
            });
        }
    }

    public void removeRow(String rowRef) {
        this.removeRow(new CellRef(rowRef).getRow());
    }

    public void removeRow(Row row) {
        this.removeRow(row.getIndex());
    }

    public void removeRow(int rowIndex) {
        int lastRowIndex = this.getLastRowIndex();
        if (rowIndex < 0 || rowIndex > lastRowIndex) {
            return;
        }
        for (GridData gridData : this.getGSheetGridsData()) {
            int startRow;
            List rowsData = gridData.getRowData();
            int n = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
            if (rowsData == null || rowIndex < startRow || rowIndex >= startRow + rowsData.size()) continue;
            rowsData.remove(rowIndex - startRow);
            this.parent.batchUpdate(r -> r.addDeleteRowsRequest(rowIndex, 1, this.getId()));
        }
    }

    public void cleanRow(String rowRef) {
        this.cleanRow(new CellRef(rowRef).getRow());
    }

    public void cleanRow(Row row) {
        this.cleanRow(row.getIndex());
    }

    public void cleanRow(int rowIndex) {
        for (GridData gridData : this.getGSheetGridsData()) {
            int startRow;
            List rowsData = gridData.getRowData();
            int n = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
            if (rowsData == null || rowIndex < startRow || rowIndex >= startRow + rowsData.size()) continue;
            ((RowData)rowsData.get(rowIndex - startRow)).clear();
            this.parent.batchUpdate(r -> r.addCleanRowRequest(rowIndex, this.getId()));
        }
    }

    public int getFirstRowIndex() {
        List gridsData = this.getGSheet().getData();
        if (gridsData == null || gridsData.size() == 0) {
            return -1;
        }
        GridData firstGridData = null;
        for (GridData gridData : gridsData) {
            if (gridData.getRowData() == null || gridData.getRowData().size() <= 0) continue;
            firstGridData = gridData;
            break;
        }
        if (firstGridData == null) {
            return -1;
        }
        return firstGridData.getStartRow() != null ? firstGridData.getStartRow() : 0;
    }

    public int getLastRowIndex() {
        List gridsData = this.getGSheet().getData();
        if (gridsData == null || gridsData.size() == 0) {
            return -1;
        }
        GridData lastGridData = null;
        for (int i = gridsData.size() - 1; i >= 0; --i) {
            GridData gridData = (GridData)gridsData.get(i);
            if (gridData.getRowData() == null || gridData.getRowData().size() <= 0) continue;
            lastGridData = gridData;
            break;
        }
        if (lastGridData == null) {
            return -1;
        }
        int startRow = lastGridData.getStartRow() != null ? lastGridData.getStartRow() : 0;
        return startRow + lastGridData.getRowData().size() - 1;
    }

    public Column getColumn(String colRef) {
        return this.getColumn(new CellRef(colRef).getCol());
    }

    public Column getColumn(int colIndex) {
        return colIndex >= 0 && colIndex <= this.getLastColumnIndex() ? new Column(this, colIndex) : null;
    }

    public void addColumn(List<?> values) {
        this.addColumn(0, values);
    }

    public void addColumn(String startRowRef, List<?> values) {
        this.addColumn(new CellRef(startRowRef).getRow(), values);
    }

    public void addColumn(int startRow, List<?> values) {
        List columnData = values.stream().map(Collections::singletonList).collect(Collectors.toList());
        this.putRange(startRow, this.getLastColumnIndex() + 1, columnData);
    }

    public void insertColumn(InsertMethod method, String columnRef, String startRowRef, List<?> values) {
        CellRef cRef = new CellRef(columnRef);
        CellRef srRef = new CellRef(startRowRef);
        this.insertColumn(method, cRef.getCol(), srRef.getRow(), values);
    }

    public void insertColumn(InsertMethod method, int columnPos, int startRow, List<?> values) {
        if (columnPos < 0 || startRow < 0 || values == null || values.isEmpty()) {
            return;
        }
        int columnIndex = method == null || method == InsertMethod.BEFORE ? columnPos : columnPos + 1;
        List columnData = values.stream().map(Collections::singletonList).collect(Collectors.toList());
        if (columnIndex > this.getLastColumnIndex()) {
            this.putRange(startRow, columnIndex, columnData);
        } else {
            for (GridData gridsDatum : this.getGSheetGridsData()) {
                for (RowData rowData : gridsDatum.getRowData()) {
                    List cellsData = rowData.getValues();
                    if (cellsData == null || columnIndex >= cellsData.size()) continue;
                    cellsData.add(columnIndex, new CellData());
                }
            }
            this.parent.batchUpdate(r -> {
                r.addInsertColumnsRequest(columnIndex, 1, this.getId());
                this.putRange(startRow, columnIndex, columnData);
            });
        }
    }

    public void moveColumn(String columnToMoveRef, InsertMethod method, String toPositionRef) {
        this.moveColumn(new CellRef(columnToMoveRef).getCol(), method, new CellRef(toPositionRef).getCol());
    }

    public void moveColumn(String columnToMoveRef, InsertMethod method, int toPositionIndex) {
        this.moveColumn(new CellRef(columnToMoveRef).getCol(), method, toPositionIndex);
    }

    public void moveColumn(int columnToMoveIndex, InsertMethod method, String toPositionRef) {
        this.moveColumn(columnToMoveIndex, method, new CellRef(toPositionRef).getCol());
    }

    public void moveColumn(int columnToMoveIndex, InsertMethod method, int toPositionIndex) {
        int pos;
        if (columnToMoveIndex < 0 || columnToMoveIndex > this.getLastColumnIndex() || toPositionIndex < 0) {
            return;
        }
        int n = pos = method == null || method == InsertMethod.BEFORE ? toPositionIndex : toPositionIndex + 1;
        if (pos != columnToMoveIndex) {
            this.parent.batchUpdate(r -> r.addMoveColumnsRequest(columnToMoveIndex, pos, 1, this.getGSheet().getProperties().getSheetId()));
        }
    }

    public void removeColumn(String colRef) {
        this.removeColumn(new CellRef(colRef).getCol());
    }

    public void removeColumn(Column column) {
        this.removeColumn(column.getIndex());
    }

    public void removeColumn(int colIndex) {
        if (colIndex < 0 || colIndex > this.getLastColumnIndex()) {
            return;
        }
        for (GridData gridData : this.getGSheetGridsData()) {
            List rowsData = gridData.getRowData();
            if (rowsData == null) continue;
            for (RowData rowData : rowsData) {
                List cellsData = rowData.getValues();
                if (cellsData == null || colIndex >= cellsData.size()) continue;
                cellsData.remove(colIndex);
            }
        }
        this.parent.batchUpdate(r -> r.addDeleteColumnsRequest(colIndex, 1, this.getId()));
    }

    public void cleanColumn(String colRef) {
        this.cleanColumn(new CellRef(colRef).getCol());
    }

    public void cleanColumn(Column column) {
        this.cleanColumn(column.getIndex());
    }

    public void cleanColumn(int colIndex) {
        if (colIndex < 0 || colIndex > this.getLastColumnIndex()) {
            return;
        }
        for (GridData gridData : this.getGSheetGridsData()) {
            List rowsData = gridData.getRowData();
            if (rowsData == null) continue;
            for (RowData rowData : rowsData) {
                List cellsData = rowData.getValues();
                if (cellsData == null || colIndex >= cellsData.size()) continue;
                cellsData.remove(colIndex);
            }
        }
        this.parent.batchUpdate(r -> r.addCleanColumnRequest(colIndex, this.getId()));
    }

    public void setColumnWidth(String colRef, int width) {
        this.setColumnWidth(new CellRef(colRef).getCol(), width);
    }

    public void setColumnWidth(int columnIndex, int width) {
        if (columnIndex < 0 || columnIndex > this.getLastColumnIndex()) {
            return;
        }
        for (GridData gridData : this.getGSheetGridsData()) {
            int startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            ArrayList<DimensionProperties> columns = gridData.getColumnMetadata();
            if (columns == null) {
                columns = new ArrayList<DimensionProperties>();
                gridData.setColumnMetadata(columns);
            }
            while (columnIndex >= startColumn + columns.size()) {
                columns.add(new DimensionProperties());
            }
            if (columnIndex < startColumn || columnIndex >= startColumn + columns.size()) continue;
            DimensionProperties columnMetadata = (DimensionProperties)columns.get(columnIndex - startColumn);
            columnMetadata.setPixelSize(Integer.valueOf(width));
            this.parent.batchUpdate(r -> r.addUpdateColumnMetadataRequest(columnIndex, columnMetadata, this.getId()));
            break;
        }
    }

    public int getFirstColumnIndex() {
        int firstColIndex = Integer.MAX_VALUE;
        List gridsData = this.getGSheet().getData();
        if (gridsData == null || gridsData.size() == 0) {
            return -1;
        }
        for (GridData gridData : gridsData) {
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty()) continue;
            int startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            firstColIndex = Math.min(firstColIndex, startColumn);
        }
        return firstColIndex != Integer.MAX_VALUE ? firstColIndex : -1;
    }

    public int getLastColumnIndex() {
        int lastColIndex = -1;
        List gridsData = this.getGSheet().getData();
        if (gridsData == null || gridsData.size() == 0) {
            return -1;
        }
        for (GridData gridData : gridsData) {
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty()) continue;
            int startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            for (RowData rowData : gridData.getRowData()) {
                if (rowData.getValues() == null) continue;
                lastColIndex = Math.max(lastColIndex, startColumn + rowData.getValues().size() - 1);
            }
        }
        return lastColIndex;
    }

    public <T> Table<T> getTable(String topLeftCellRef, Class<T> recordType) {
        CellRef ref = new CellRef(topLeftCellRef);
        return this.getTable(ref.getRow(), ref.getCol(), recordType);
    }

    public <T> Table<T> getTable(int headerTopRow, int headerLeftCol, Class<T> recordType) {
        return new Table<T>(this, headerTopRow, headerLeftCol, headerTopRow, this.getLastColumnIndex(), recordType);
    }

    public <T> Table<T> getTable(String headerTopLeftCellRef, String headerBottomRightCellRef, Class<T> recordType) {
        CellRef tlRef = new CellRef(headerTopLeftCellRef);
        CellRef brRef = new CellRef(headerBottomRightCellRef);
        return this.getTable(tlRef.getRow(), tlRef.getCol(), brRef.getRow(), brRef.getCol(), recordType);
    }

    public <T> Table<T> getTable(int headerTopRow, int headerLeftCol, int headerBottomRow, int headerRightCol, Class<T> recordType) {
        return new Table<T>(this, headerTopRow, headerLeftCol, headerBottomRow, headerRightCol, recordType);
    }

    public <T> Table<T> findTable(Class<T> recordType, String ... keywords) {
        return this.findTable(recordType, MatchMethod.EXACT, keywords);
    }

    public <T> Table<T> findTable(Class<T> recordType, MatchMethod matchMethod, String ... keywords) {
        Row headerRow;
        if (matchMethod == null) {
            matchMethod = MatchMethod.EXACT;
        }
        if ((headerRow = this.findRow(matchMethod, keywords)) != null) {
            int topRow = Integer.MAX_VALUE;
            int leftCol = Integer.MAX_VALUE;
            int botRow = -1;
            int rightCol = -1;
            for (Cell cell : headerRow) {
                CellRange region = cell.getMergedRegion();
                if (region != null) {
                    topRow = Math.min(topRow, region.getFirstRow());
                    leftCol = Math.min(leftCol, region.getFirstCol());
                    botRow = Math.max(botRow, region.getLastRow());
                    rightCol = Math.max(rightCol, region.getLastCol());
                    continue;
                }
                topRow = Math.min(topRow, cell.getRowIndex());
                leftCol = Math.min(leftCol, cell.getColumnIndex());
                botRow = Math.max(botRow, cell.getRowIndex());
                rightCol = Math.max(rightCol, cell.getColumnIndex());
            }
            return this.getTable(topRow, leftCol, botRow, rightCol, recordType);
        }
        return null;
    }

    public <T> Table<T> insertTable(List<T> records) {
        return this.insertTable(0, 0, records);
    }

    public <T> Table<T> insertTable(String topLeftCellRef, List<T> records) {
        CellRef ref = new CellRef(topLeftCellRef);
        return this.insertTable(ref.getRow(), ref.getCol(), records);
    }

    public <T> Table<T> insertTable(int startRow, int startCol, List<T> records) {
        return startRow >= 0 && startCol >= 0 && records != null && records.size() > 0 ? new Table<T>(this, startRow, startCol, records) : null;
    }

    public void moveTo(int newPos) {
        List sheets = this.parent.getGSpreadsheet().getSheets();
        if (newPos < 0 || newPos > sheets.size() || newPos == this.sheetIndex) {
            return;
        }
        com.google.api.services.sheets.v4.model.Sheet gSheet = (com.google.api.services.sheets.v4.model.Sheet)sheets.remove(this.sheetIndex);
        sheets.add(newPos, gSheet);
        gSheet.getProperties().setIndex(Integer.valueOf(newPos));
        this.sheetIndex = newPos;
        this.parent.batchUpdate(r -> r.addUpdateSheetPropertiesRequest(gSheet, "index"));
    }

    public void rename(String newName) {
        if (this.parent.getSheetNames().stream().anyMatch(newName::equalsIgnoreCase)) {
            throw new IllegalArgumentException(String.format("The sheet with name '%s' already exist in the spreadsheet.", newName));
        }
        com.google.api.services.sheets.v4.model.Sheet gSheet = this.getGSheet();
        gSheet.getProperties().setTitle(newName);
        this.parent.batchUpdate(r -> r.addUpdateSheetPropertiesRequest(gSheet, "title"));
    }

    public Sheet cloneAs(String clonedSheetName) {
        com.google.api.services.sheets.v4.model.Sheet gSheet = this.getGSheet();
        com.google.api.services.sheets.v4.model.Sheet gSheetClone = gSheet.clone();
        int clonedSheetIndex = this.parent.getGSpreadsheet().getSheets().size();
        SpreadsheetUpdateRequestsBatch request = new SpreadsheetUpdateRequestsBatch(this.getDocument());
        request.addDuplicateSheetRequest(gSheet, clonedSheetIndex, clonedSheetName);
        BatchUpdateSpreadsheetResponse response = request.send().get(0);
        gSheetClone.setProperties(((Response)response.getReplies().get(0)).getDuplicateSheet().getProperties());
        this.parent.getGSpreadsheet().getSheets().add(gSheetClone);
        return new Sheet(this.parent, clonedSheetIndex);
    }

    public Sheet copyTo(SpreadsheetDocument destDoc) {
        CopySheetToAnotherSpreadsheetRequest requestBody = new CopySheetToAnotherSpreadsheetRequest();
        requestBody.setDestinationSpreadsheetId(destDoc.getId());
        try {
            SheetProperties props = (SheetProperties)this.parent.getSheetsService().spreadsheets().sheets().copyTo(this.getDocument().getId(), Integer.valueOf(this.getId()), requestBody).execute();
            destDoc.reload();
            return destDoc.selectSheet(props.getIndex());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Copying of sheet '%s' has failed.", this.getName()), e);
        }
    }

    @Override
    public Iterator<Row> iterator() {
        return new RowIterator(this.getGSheet());
    }

    public com.google.api.services.sheets.v4.model.Sheet getGSheet() {
        return (com.google.api.services.sheets.v4.model.Sheet)this.parent.getGSpreadsheet().getSheets().get(this.sheetIndex);
    }

    List<GridData> getGSheetGridsData() {
        com.google.api.services.sheets.v4.model.Sheet gSheet = this.getGSheet();
        ArrayList<GridData> gridsData = gSheet.getData();
        if (gridsData == null) {
            gridsData = new ArrayList<GridData>();
            gSheet.setData(gridsData);
        }
        if (gridsData.isEmpty()) {
            gridsData.add(new GridData());
        }
        return gridsData;
    }

    int getMaxRowsCount() {
        int maxRowsCount = 0;
        GridData lastGridData = null;
        int startMetaRow = 0;
        List<GridData> gridsData = this.getGSheetGridsData();
        for (int i = gridsData.size() - 1; i >= 0; --i) {
            GridData gridData = gridsData.get(i);
            if (gridData.getRowMetadata() == null || gridData.getRowMetadata().size() <= 0) continue;
            startMetaRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
            lastGridData = gridData;
            break;
        }
        if (lastGridData != null) {
            maxRowsCount = startMetaRow + lastGridData.getRowMetadata().size();
        }
        return maxRowsCount;
    }

    void appendRowsMetadata(int rowsAmount) {
        int i;
        List<GridData> gridsData = this.getGSheetGridsData();
        GridData lastGridData = null;
        for (i = gridsData.size() - 1; i >= 0; --i) {
            GridData gridData = gridsData.get(i);
            if (gridData.getRowMetadata() == null || gridData.getRowMetadata().size() <= 0) continue;
            lastGridData = gridData;
            break;
        }
        if (lastGridData == null) {
            lastGridData = gridsData.get(gridsData.size() - 1);
            lastGridData.setRowMetadata(new ArrayList());
        }
        for (i = rowsAmount; i >= 0; --i) {
            lastGridData.getRowMetadata().add(new DimensionProperties());
        }
    }

    int getMaxColumnsCount() {
        int maxColumnsCount = 0;
        for (GridData gridData : this.getGSheetGridsData()) {
            if (gridData.getColumnMetadata() == null || gridData.getColumnMetadata().isEmpty()) continue;
            int startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            maxColumnsCount = Math.max(maxColumnsCount, startColumn + gridData.getColumnMetadata().size());
        }
        return maxColumnsCount;
    }

    void appendColumnMetadata(int columnsAmount) {
        int i;
        List<GridData> gridsData = this.getGSheetGridsData();
        GridData lastGridData = null;
        for (i = gridsData.size() - 1; i >= 0; --i) {
            GridData gridData = gridsData.get(i);
            if (gridData.getColumnMetadata() == null || gridData.getColumnMetadata().size() <= 0) continue;
            lastGridData = gridData;
            break;
        }
        if (lastGridData == null) {
            lastGridData = gridsData.get(gridsData.size() - 1);
            lastGridData.setColumnMetadata(new ArrayList());
        }
        for (i = columnsAmount; i >= 0; --i) {
            lastGridData.getColumnMetadata().add(new DimensionProperties());
        }
    }

    private class RowIterator
    implements Iterator<Row> {
        private com.google.api.services.sheets.v4.model.Sheet gSheet;
        private int gridIndex = 0;
        private int rowIndex = 0;
        private int rowsCount;

        public RowIterator(com.google.api.services.sheets.v4.model.Sheet gSheet) {
            this.gSheet = gSheet;
            this.rowsCount = gSheet.getData() != null ? gSheet.getData().stream().mapToInt(gd -> gd.getRowData() != null ? gd.getRowData().size() : 0).sum() : 0;
        }

        @Override
        public boolean hasNext() {
            if (this.rowIndex < this.rowsCount) {
                int startRow;
                GridData gridData = (GridData)this.gSheet.getData().get(this.gridIndex);
                int n = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                while (gridData.getRowData() == null || this.rowIndex >= startRow + gridData.getRowData().size()) {
                    gridData = (GridData)this.gSheet.getData().get(++this.gridIndex);
                    startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                }
                while (this.rowIndex < startRow) {
                    ++this.rowIndex;
                }
                RowData nextRow = (RowData)gridData.getRowData().get(this.rowIndex - startRow);
                while (this.rowIndex < startRow + gridData.getRowData().size() && nextRow == null) {
                    nextRow = (RowData)gridData.getRowData().get(++this.rowIndex - startRow);
                }
                return nextRow != null;
            }
            return false;
        }

        @Override
        public Row next() {
            return new Row(Sheet.this, this.rowIndex++);
        }
    }
}

