/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.GridData;
import com.google.api.services.sheets.v4.model.RowData;
import eu.easyrpa.openframework.google.sheets.Cell;
import eu.easyrpa.openframework.google.sheets.CellRef;
import eu.easyrpa.openframework.google.sheets.Sheet;
import eu.easyrpa.openframework.google.sheets.SpreadsheetDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Row
implements Iterable<Cell> {
    private Sheet parent;
    private int rowIndex;

    protected Row(Sheet parent, int rowIndex) {
        this.parent = parent;
        this.rowIndex = rowIndex;
    }

    public SpreadsheetDocument getDocument() {
        return this.parent.getDocument();
    }

    public Sheet getSheet() {
        return this.parent;
    }

    public int getIndex() {
        return this.rowIndex;
    }

    public CellRef getReference() {
        return new CellRef(this.rowIndex, 0);
    }

    public Object getValue(String cellRef) {
        return this.getValue(new CellRef(cellRef).getCol(), Object.class);
    }

    public <T> T getValue(String cellRef, Class<T> valueType) {
        return this.getValue(new CellRef(cellRef).getCol(), valueType);
    }

    public Object getValue(int colIndex) {
        return this.getValue(colIndex, Object.class);
    }

    public <T> T getValue(int colIndex, Class<T> valueType) {
        Cell cell = this.getCell(colIndex);
        return cell != null ? (T)cell.getValue(valueType) : null;
    }

    public void setValue(String cellRef, Object value) {
        this.setValue(new CellRef(cellRef).getCol(), value);
    }

    public void setValue(int colIndex, Object value) {
        int columnsAmountToAppend = colIndex + 1 - this.parent.getMaxColumnsCount();
        this.getDocument().batchUpdate(r -> {
            Cell cell;
            if (columnsAmountToAppend > 0) {
                this.parent.appendColumnMetadata(columnsAmountToAppend);
                r.addAppendColumnsRequest(columnsAmountToAppend, this.parent.getId());
            }
            if ((cell = this.getCell(colIndex)) == null) {
                cell = this.createCell(colIndex);
            }
            cell.setValue(value);
        });
    }

    public List<Object> getValues() {
        return this.getValues(Object.class);
    }

    public <T> List<T> getValues(Class<T> valueType) {
        return this.getRange(this.getFirstCellIndex(), this.getLastCellIndex(), valueType);
    }

    public void setValues(List<?> values) {
        this.putRange(0, values);
    }

    public List<Object> getRange(String startRef, String endRef) {
        return this.getRange(new CellRef(startRef).getCol(), new CellRef(endRef).getCol());
    }

    public <T> List<T> getRange(String startRef, String endRef, Class<T> valueType) {
        return this.getRange(new CellRef(startRef).getCol(), new CellRef(endRef).getCol(), valueType);
    }

    public List<Object> getRange(int startCol, int endCol) {
        return this.getRange(startCol, endCol, Object.class);
    }

    public <T> List<T> getRange(int startCol, int endCol, Class<T> valueType) {
        ArrayList<T> values = new ArrayList<T>();
        int c1 = Math.min(startCol, endCol);
        int c2 = Math.max(startCol, endCol);
        for (int col = c1; col <= c2; ++col) {
            values.add(this.getValue(col, valueType));
        }
        return values;
    }

    public void putRange(String startRef, List<?> values) {
        this.putRange(new CellRef(startRef).getCol(), values);
    }

    public void putRange(int startCol, List<?> values) {
        if (values != null) {
            int columnsAmountToAppend = startCol + values.size() - this.parent.getMaxColumnsCount();
            this.getDocument().batchUpdate(r -> {
                if (columnsAmountToAppend > 0) {
                    this.parent.appendColumnMetadata(columnsAmountToAppend);
                    r.addAppendColumnsRequest(columnsAmountToAppend, this.parent.getId());
                }
                int col = startCol;
                for (Object cellValue : values) {
                    Cell cell = this.getCell(col);
                    if (cell == null) {
                        cell = this.createCell(col);
                    }
                    cell.setValue(cellValue);
                    ++col;
                }
            });
        }
    }

    public Cell getCell(String cellRef) {
        return this.getCell(new CellRef(cellRef).getCol());
    }

    public Cell getCell(int colIndex) {
        int cellDataIndex = -1;
        List cellsData = null;
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startColumn;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty()) continue;
            int startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
            int n = startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            if (this.rowIndex < startRow || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            cellDataIndex = colIndex - startColumn;
            cellsData = ((RowData)gridData.getRowData().get(this.rowIndex - startRow)).getValues();
            break;
        }
        if (cellsData != null && cellDataIndex >= 0 && cellDataIndex < cellsData.size()) {
            CellData cell = (CellData)cellsData.get(cellDataIndex);
            return cell != null ? new Cell(this.parent, this.rowIndex, colIndex) : null;
        }
        return null;
    }

    public Cell createCell(int colIndex) {
        int i;
        GridData relatedGridData = null;
        RowData row = null;
        for (GridData gridData : this.parent.getGSheetGridsData()) {
            int startRow;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty() || this.rowIndex < (startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0) || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            relatedGridData = gridData;
            row = (RowData)gridData.getRowData().get(this.rowIndex - startRow);
            break;
        }
        if (relatedGridData == null || row == null) {
            return null;
        }
        int startColumn = relatedGridData.getStartColumn() != null ? relatedGridData.getStartColumn() : 0;
        ArrayList<CellData> cellsData = row.getValues();
        if (cellsData == null) {
            cellsData = new ArrayList<CellData>();
            row.setValues(cellsData);
        }
        if (colIndex < startColumn) {
            for (i = startColumn - colIndex; i > 0; --i) {
                if (cellsData.isEmpty()) {
                    cellsData.add(new CellData());
                    continue;
                }
                cellsData.add(0, new CellData());
            }
            relatedGridData.setStartColumn(Integer.valueOf(colIndex));
        } else if (colIndex > startColumn + cellsData.size() - 1) {
            for (i = colIndex - startColumn - cellsData.size() + 1; i > 0; --i) {
                cellsData.add(new CellData());
            }
        }
        return new Cell(this.parent, this.rowIndex, colIndex);
    }

    public Cell addCell(Object value) {
        Cell cell = this.createCell(this.getLastCellIndex() + 1);
        cell.setValue(value);
        return cell;
    }

    public int getFirstCellIndex() {
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startRow;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty() || this.rowIndex < (startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0) || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            List cellsData = ((RowData)gridData.getRowData().get(this.rowIndex - startRow)).getValues();
            if (cellsData == null || cellsData.isEmpty()) break;
            return gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
        }
        return -1;
    }

    public int getLastCellIndex() {
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startRow;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty() || this.rowIndex < (startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0) || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            int startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            List cellsData = ((RowData)gridData.getRowData().get(this.rowIndex - startRow)).getValues();
            if (cellsData == null) break;
            return startColumn + cellsData.size() - 1;
        }
        return -1;
    }

    @Override
    public Iterator<Cell> iterator() {
        int startCol = 0;
        RowData row = null;
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startRow;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty() || this.rowIndex < (startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0) || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            startCol = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            row = (RowData)gridData.getRowData().get(this.rowIndex - startRow);
            break;
        }
        return new CellIterator(startCol, row);
    }

    public RowData getGRow() {
        RowData row = null;
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startRow;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty() || this.rowIndex < (startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0) || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            row = (RowData)gridData.getRowData().get(this.rowIndex - startRow);
            break;
        }
        return row;
    }

    private class CellIterator
    implements Iterator<Cell> {
        private RowData gSheetRow;
        private int index = 0;
        private int cellsCount;
        private int startCol;

        public CellIterator(int startCol, RowData gSheetRow) {
            this.startCol = startCol;
            this.gSheetRow = gSheetRow;
            this.cellsCount = gSheetRow != null && gSheetRow.getValues() != null ? gSheetRow.getValues().size() : 0;
        }

        @Override
        public boolean hasNext() {
            if (this.index < this.cellsCount) {
                CellData nextCell = (CellData)this.gSheetRow.getValues().get(this.index);
                while (nextCell == null && this.index + 1 < this.cellsCount) {
                    nextCell = (CellData)this.gSheetRow.getValues().get(++this.index);
                }
                return nextCell != null;
            }
            return false;
        }

        @Override
        public Cell next() {
            return new Cell(Row.this.parent, Row.this.rowIndex, this.startCol + this.index++);
        }
    }
}

