/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.Sheets;
import eu.easyrpa.openframework.google.services.AuthorizationPerformer;
import eu.easyrpa.openframework.google.services.GoogleServicesProvider;
import eu.easyrpa.openframework.google.sheets.SpreadsheetDocument;
import javax.inject.Inject;

public class GoogleSheets {
    private Sheets sheetsService;
    private GoogleServicesProvider googleServicesProvider;

    public GoogleSheets() {
        this.googleServicesProvider = new GoogleServicesProvider();
    }

    @Inject
    public GoogleSheets(GoogleServicesProvider googleServicesProvider) {
        this.googleServicesProvider = googleServicesProvider;
    }

    public GoogleSheets onAuthorization(AuthorizationPerformer authorizationPerformer) {
        this.googleServicesProvider.onAuthorization(authorizationPerformer);
        this.sheetsService = null;
        return this;
    }

    public GoogleSheets secret(String vaultAlias) {
        this.googleServicesProvider.secret(vaultAlias);
        return this;
    }

    public GoogleSheets secret(String userId, String secret) {
        this.googleServicesProvider.secret(userId, secret);
        this.sheetsService = null;
        return this;
    }

    public SpreadsheetDocument getSpreadsheet(String spreadsheetId) {
        this.initService();
        return new SpreadsheetDocument(this.sheetsService, spreadsheetId);
    }

    private void initService() {
        if (this.sheetsService == null) {
            this.sheetsService = (Sheets)this.googleServicesProvider.getService(Sheets.class, new String[]{"https://www.googleapis.com/auth/spreadsheets"});
        }
    }
}

