/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.GridData;
import com.google.api.services.sheets.v4.model.RowData;
import eu.easyrpa.openframework.google.sheets.Cell;
import eu.easyrpa.openframework.google.sheets.CellRef;
import eu.easyrpa.openframework.google.sheets.Sheet;
import eu.easyrpa.openframework.google.sheets.SpreadsheetDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Column
implements Iterable<Cell> {
    private Sheet parent;
    private int columnIndex;

    protected Column(Sheet parent, int columnIndex) {
        this.parent = parent;
        this.columnIndex = columnIndex;
    }

    public SpreadsheetDocument getDocument() {
        return this.parent.getDocument();
    }

    public Sheet getSheet() {
        return this.parent;
    }

    public int getIndex() {
        return this.columnIndex;
    }

    public CellRef getReference() {
        return new CellRef(0, this.columnIndex);
    }

    public Object getValue(String cellRef) {
        return this.getValue(new CellRef(cellRef).getRow(), Object.class);
    }

    public <T> T getValue(String cellRef, Class<T> valueType) {
        return this.getValue(new CellRef(cellRef).getRow(), valueType);
    }

    public Object getValue(int rowIndex) {
        return this.getValue(rowIndex, Object.class);
    }

    public <T> T getValue(int rowIndex, Class<T> valueType) {
        Cell cell = this.getCell(rowIndex);
        return cell != null ? (T)cell.getValue(valueType) : null;
    }

    public void setValue(String cellRef, Object value) {
        this.setValue(new CellRef(cellRef).getRow(), value);
    }

    public void setValue(int rowIndex, Object value) {
        int rowsAmountToAppend = rowIndex + 1 - this.parent.getMaxRowsCount();
        this.getDocument().batchUpdate(r -> {
            Cell cell;
            if (rowsAmountToAppend > 0) {
                this.parent.appendRowsMetadata(rowsAmountToAppend);
                r.addAppendRowsRequest(rowsAmountToAppend, this.parent.getId());
            }
            if ((cell = this.getCell(rowIndex)) == null) {
                cell = this.createCell(rowIndex);
            }
            cell.setValue(value);
        });
    }

    public List<Object> getValues() {
        return this.getValues(Object.class);
    }

    public <T> List<T> getValues(Class<T> valueType) {
        return this.getRange(this.getFirstRowIndex(), this.getLastRowIndex(), valueType);
    }

    public void setValues(List<?> values) {
        this.putRange(0, values);
    }

    public List<Object> getRange(String startRef, String endRef) {
        return this.getRange(new CellRef(startRef).getRow(), new CellRef(endRef).getRow());
    }

    public <T> List<T> getRange(String startRef, String endRef, Class<T> valueType) {
        return this.getRange(new CellRef(startRef).getRow(), new CellRef(endRef).getRow(), valueType);
    }

    public List<Object> getRange(int startRow, int endRow) {
        return this.getRange(startRow, endRow, Object.class);
    }

    public <T> List<T> getRange(int startRow, int endRow, Class<T> valueType) {
        ArrayList<T> values = new ArrayList<T>();
        int r1 = Math.min(startRow, endRow);
        int r2 = Math.max(startRow, endRow);
        for (int row = r1; row <= r2; ++row) {
            values.add(this.getValue(row, valueType));
        }
        return values;
    }

    public void putRange(String startRef, List<?> values) {
        this.putRange(new CellRef(startRef).getRow(), values);
    }

    public void putRange(int startRow, List<?> values) {
        if (values != null) {
            int rowsAmountToAppend = startRow + values.size() - this.parent.getMaxRowsCount();
            this.getDocument().batchUpdate(r -> {
                if (rowsAmountToAppend > 0) {
                    this.parent.appendRowsMetadata(rowsAmountToAppend);
                    r.addAppendRowsRequest(rowsAmountToAppend, this.parent.getId());
                }
                int row = startRow;
                for (Object cellValue : values) {
                    Cell cell = this.getCell(row);
                    if (cell == null) {
                        cell = this.createCell(row);
                    }
                    cell.setValue(cellValue);
                    ++row;
                }
            });
        }
    }

    public Cell getCell(String cellRef) {
        return this.getCell(new CellRef(cellRef).getRow());
    }

    public Cell getCell(int rowIndex) {
        int cellDataIndex = -1;
        List cellsData = null;
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startColumn;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty()) continue;
            int startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
            int n = startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            if (rowIndex < startRow || rowIndex >= startRow + gridData.getRowData().size()) continue;
            cellDataIndex = this.columnIndex - startColumn;
            cellsData = ((RowData)gridData.getRowData().get(rowIndex - startRow)).getValues();
            break;
        }
        if (cellsData != null && cellDataIndex >= 0 && cellDataIndex < cellsData.size()) {
            CellData cell = (CellData)cellsData.get(cellDataIndex);
            return cell != null ? new Cell(this.parent, rowIndex, this.columnIndex) : null;
        }
        return null;
    }

    public Cell createCell(int rowIndex) {
        int startRow;
        int i;
        RowData rowData = null;
        GridData relatedGridData = null;
        List<GridData> gridsData = this.parent.getGSheetGridsData();
        int lastRowIndex = this.getLastRowIndex();
        if (rowIndex > lastRowIndex) {
            GridData lastGridData = gridsData.get(gridsData.size() - 1);
            ArrayList<RowData> rowsData = lastGridData.getRowData();
            if (rowsData == null || rowsData.isEmpty()) {
                rowData = new RowData();
                rowsData = new ArrayList<RowData>();
                rowsData.add(rowData);
                lastGridData.setRowData(rowsData);
                lastGridData.setStartRow(Integer.valueOf(rowIndex));
            } else {
                for (i = lastRowIndex + 1; i <= rowIndex; ++i) {
                    rowsData.add(new RowData());
                }
                startRow = lastGridData.getStartRow() != null ? lastGridData.getStartRow() : 0;
                rowData = (RowData)rowsData.get(rowIndex - startRow);
            }
        } else {
            for (int gridIndex = 0; gridIndex < gridsData.size(); ++gridIndex) {
                GridData gridData = gridsData.get(gridIndex);
                int n = startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                if (rowIndex < startRow) {
                    rowData = new RowData();
                    relatedGridData = new GridData();
                    relatedGridData.setStartRow(Integer.valueOf(rowIndex));
                    relatedGridData.setRowData(new ArrayList());
                    relatedGridData.getRowData().add(rowData);
                    gridsData.add(gridIndex, relatedGridData);
                    break;
                }
                if (rowIndex < startRow + gridData.getRowData().size()) {
                    relatedGridData = gridData;
                    rowData = (RowData)gridData.getRowData().get(rowIndex - startRow);
                    break;
                }
                if (rowIndex != startRow + gridData.getRowData().size()) continue;
                relatedGridData = gridData;
                rowData = new RowData();
                gridData.getRowData().add(rowData);
                break;
            }
        }
        if (relatedGridData == null || rowData == null) {
            return null;
        }
        int startColumn = relatedGridData.getStartColumn() != null ? relatedGridData.getStartColumn() : 0;
        ArrayList<CellData> cellsData = rowData.getValues();
        if (cellsData == null) {
            cellsData = new ArrayList<CellData>();
            rowData.setValues(cellsData);
        }
        if (this.columnIndex < startColumn) {
            for (i = startColumn - this.columnIndex; i > 0; --i) {
                cellsData.add(0, new CellData());
            }
            relatedGridData.setStartColumn(Integer.valueOf(this.columnIndex));
        } else if (this.columnIndex > startColumn + cellsData.size() - 1) {
            for (i = this.columnIndex - startColumn - cellsData.size() + 1; i > 0; --i) {
                cellsData.add(new CellData());
            }
        }
        return new Cell(this.parent, rowIndex, this.columnIndex);
    }

    public int getFirstRowIndex() {
        return this.parent.getFirstRowIndex();
    }

    public int getLastRowIndex() {
        return this.parent.getLastRowIndex();
    }

    public boolean isEmpty() {
        for (Cell cell : this) {
            if (cell == null || cell.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Cell> iterator() {
        return new CellIterator(this.parent.getGSheet());
    }

    private class CellIterator
    implements Iterator<Cell> {
        private List<GridData> gridsData;
        private int index = 0;
        private int cellsCount;

        public CellIterator(com.google.api.services.sheets.v4.model.Sheet gSheet) {
            this.gridsData = gSheet.getData();
            GridData lastGridData = null;
            for (int i = this.gridsData.size() - 1; i >= 0; --i) {
                GridData gridData = this.gridsData.get(i);
                if (gridData.getRowData() == null || gridData.getRowData().size() <= 0) continue;
                lastGridData = gridData;
                break;
            }
            int startRow = lastGridData != null && lastGridData.getStartRow() != null ? lastGridData.getStartRow() : 0;
            this.cellsCount = lastGridData != null ? startRow + lastGridData.getRowData().size() : 0;
        }

        @Override
        public boolean hasNext() {
            int cellDataIndex = -1;
            RowData nextRow = null;
            while (nextRow == null && this.index < this.cellsCount) {
                for (GridData gridData : this.gridsData) {
                    int startColumn;
                    if (gridData.getRowData() == null || gridData.getRowData().isEmpty()) continue;
                    int startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
                    int n = startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
                    if (this.index < startRow || this.index >= startRow + gridData.getRowData().size()) continue;
                    cellDataIndex = Column.this.columnIndex - startColumn;
                    nextRow = (RowData)gridData.getRowData().get(this.index - startRow);
                    break;
                }
                if (nextRow != null && nextRow.getValues() != null && cellDataIndex >= 0 && cellDataIndex < nextRow.getValues().size() && nextRow.getValues().get(cellDataIndex) != null) continue;
                nextRow = null;
                ++this.index;
            }
            return nextRow != null;
        }

        @Override
        public Cell next() {
            return new Cell(Column.this.parent, this.index++, Column.this.columnIndex);
        }
    }
}

