/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.model.Border;
import com.google.api.services.sheets.v4.model.Borders;
import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.CellFormat;
import com.google.api.services.sheets.v4.model.Color;
import com.google.api.services.sheets.v4.model.NumberFormat;
import com.google.api.services.sheets.v4.model.Padding;
import com.google.api.services.sheets.v4.model.TextFormat;
import com.google.api.services.sheets.v4.model.TextRotation;
import eu.easyrpa.openframework.google.sheets.Cell;
import eu.easyrpa.openframework.google.sheets.constants.BorderStyle;
import eu.easyrpa.openframework.google.sheets.constants.FontFamily;
import eu.easyrpa.openframework.google.sheets.constants.HorizontalAlignment;
import eu.easyrpa.openframework.google.sheets.constants.NumberFormats;
import eu.easyrpa.openframework.google.sheets.constants.VerticalAlignment;
import eu.easyrpa.openframework.google.sheets.constants.WrapStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CellStyle {
    private CellFormat cellFormat;
    private Cell cell;
    private List<String> dirtyFields = new ArrayList<String>();

    public CellStyle() {
        this.cellFormat = new CellFormat();
    }

    public CellStyle(Cell cell) {
        CellFormat cellFormat = cell.getGCell().getUserEnteredFormat();
        this.cellFormat = cellFormat != null ? cellFormat.clone() : new CellFormat();
        this.cell = cell;
    }

    public CellStyle font(FontFamily font) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setFontFamily(font.getName());
        this.dirtyFields.add("userEnteredFormat.textFormat.fontFamily");
        return this;
    }

    public FontFamily getFont() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null && textFormat.getFontFamily() != null) {
            return FontFamily.getValue(textFormat.getFontFamily());
        }
        return null;
    }

    public CellStyle fontSize(int fontSize) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setFontSize(Integer.valueOf(fontSize));
        this.dirtyFields.add("userEnteredFormat.textFormat.fontSize");
        return this;
    }

    public Integer getFontSize() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null) {
            return textFormat.getFontSize();
        }
        return null;
    }

    public CellStyle bold(boolean isBold) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setBold(Boolean.valueOf(isBold));
        this.dirtyFields.add("userEnteredFormat.textFormat.bold");
        return this;
    }

    public boolean isBold() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null && textFormat.getBold() != null) {
            return textFormat.getBold();
        }
        return false;
    }

    public CellStyle italic(boolean isItalic) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setItalic(Boolean.valueOf(isItalic));
        this.dirtyFields.add("userEnteredFormat.textFormat.italic");
        return this;
    }

    public boolean isItalic() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null && textFormat.getItalic() != null) {
            return textFormat.getItalic();
        }
        return false;
    }

    public CellStyle strikeout(boolean isStrikeout) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setStrikethrough(Boolean.valueOf(isStrikeout));
        this.dirtyFields.add("userEnteredFormat.textFormat.strikethrough");
        return this;
    }

    public boolean isStrikeout() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null && textFormat.getStrikethrough() != null) {
            return textFormat.getStrikethrough();
        }
        return false;
    }

    public CellStyle underline(boolean isUnderline) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setUnderline(Boolean.valueOf(isUnderline));
        this.dirtyFields.add("userEnteredFormat.textFormat.underline");
        return this;
    }

    public boolean isUnderline() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null && textFormat.getUnderline() != null) {
            return textFormat.getUnderline();
        }
        return false;
    }

    public CellStyle color(java.awt.Color color) {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat == null) {
            textFormat = new TextFormat();
            this.cellFormat.setTextFormat(textFormat);
        }
        textFormat.setForegroundColor(this.toGoogleColor(color));
        this.dirtyFields.add("userEnteredFormat.textFormat.foregroundColor");
        return this;
    }

    public java.awt.Color getColor() {
        TextFormat textFormat = this.cellFormat.getTextFormat();
        if (textFormat != null && textFormat.getForegroundColor() != null) {
            Color color = textFormat.getForegroundColor();
            return new java.awt.Color(color.getRed().floatValue(), color.getGreen().floatValue(), color.getBlue().floatValue(), color.getAlpha().floatValue());
        }
        return null;
    }

    public CellStyle format(NumberFormats format) {
        NumberFormat numberFormat = this.cellFormat.getNumberFormat();
        if (numberFormat == null) {
            numberFormat = new NumberFormat();
            this.cellFormat.setNumberFormat(numberFormat);
        }
        numberFormat.setType(format.name());
        this.dirtyFields.add("userEnteredFormat.numberFormat.type");
        return this;
    }

    public NumberFormats getFormatType() {
        NumberFormat numberFormat = this.cellFormat.getNumberFormat();
        if (numberFormat != null && numberFormat.getType() != null) {
            return NumberFormats.valueOf(numberFormat.getType());
        }
        return null;
    }

    public CellStyle format(String pattern) {
        NumberFormat numberFormat = this.cellFormat.getNumberFormat();
        if (numberFormat == null) {
            numberFormat = new NumberFormat();
            this.cellFormat.setNumberFormat(numberFormat);
        }
        numberFormat.setPattern(pattern);
        this.dirtyFields.add("userEnteredFormat.numberFormat.pattern");
        return this;
    }

    public String getFormatPattern() {
        NumberFormat numberFormat = this.cellFormat.getNumberFormat();
        if (numberFormat != null) {
            return numberFormat.getPattern();
        }
        return null;
    }

    public CellStyle background(java.awt.Color color) {
        this.cellFormat.setBackgroundColor(this.toGoogleColor(color));
        this.dirtyFields.add("userEnteredFormat.backgroundColor");
        return this;
    }

    public java.awt.Color getBackground() {
        Color color = this.cellFormat.getBackgroundColor();
        if (color != null) {
            return new java.awt.Color(color.getRed().floatValue(), color.getGreen().floatValue(), color.getBlue().floatValue(), color.getAlpha().floatValue());
        }
        return null;
    }

    public CellStyle hAlign(HorizontalAlignment hAlign) {
        this.cellFormat.setHorizontalAlignment(hAlign.name());
        this.dirtyFields.add("userEnteredFormat.horizontalAlignment");
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        if (this.cellFormat.getHorizontalAlignment() != null) {
            return HorizontalAlignment.valueOf(this.cellFormat.getHorizontalAlignment());
        }
        return null;
    }

    public CellStyle vAlign(VerticalAlignment vAlign) {
        this.cellFormat.setVerticalAlignment(vAlign.name());
        this.dirtyFields.add("userEnteredFormat.verticalAlignment");
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        if (this.cellFormat.getVerticalAlignment() != null) {
            return VerticalAlignment.valueOf(this.cellFormat.getVerticalAlignment());
        }
        return null;
    }

    public CellStyle wrapStrategy(WrapStrategy strategy) {
        this.cellFormat.setWrapStrategy(strategy.name());
        this.dirtyFields.add("userEnteredFormat.wrapStrategy");
        return this;
    }

    public WrapStrategy getWrapStrategy() {
        if (this.cellFormat.getWrapStrategy() != null) {
            return WrapStrategy.valueOf(this.cellFormat.getWrapStrategy());
        }
        return null;
    }

    public CellStyle rotation(int rotation) {
        TextRotation textRotation = this.cellFormat.getTextRotation();
        if (textRotation == null) {
            textRotation = new TextRotation();
            this.cellFormat.setTextRotation(textRotation);
        }
        textRotation.setAngle(Integer.valueOf(rotation));
        this.dirtyFields.add("userEnteredFormat.textRotation.angle");
        return this;
    }

    public Integer getRotation() {
        TextRotation textRotation = this.cellFormat.getTextRotation();
        if (textRotation != null) {
            return textRotation.getAngle();
        }
        return null;
    }

    public CellStyle vertical(boolean isVertical) {
        TextRotation textRotation = this.cellFormat.getTextRotation();
        if (textRotation == null) {
            textRotation = new TextRotation();
            this.cellFormat.setTextRotation(textRotation);
        }
        textRotation.setVertical(Boolean.valueOf(isVertical));
        this.dirtyFields.add("userEnteredFormat.textRotation.vertical");
        return this;
    }

    public boolean isVertical() {
        TextRotation textRotation = this.cellFormat.getTextRotation();
        if (textRotation != null && textRotation.getVertical() != null) {
            return textRotation.getVertical();
        }
        return false;
    }

    public CellStyle borders(BorderStyle ... styles) {
        BorderStyle[] borderStyleArray;
        if (styles.length == 4) {
            borderStyleArray = styles;
        } else {
            BorderStyle[] borderStyleArray2 = new BorderStyle[4];
            borderStyleArray2[0] = styles[0];
            borderStyleArray2[1] = styles[0];
            borderStyleArray2[2] = styles[0];
            borderStyleArray = borderStyleArray2;
            borderStyleArray2[3] = styles[0];
        }
        BorderStyle[] borderStyles = borderStyleArray;
        Borders borders = this.cellFormat.getBorders();
        if (borders == null) {
            borders = new Borders();
            this.cellFormat.setBorders(borders);
        }
        if (borderStyles[0] != null) {
            Border topBorder = borders.getTop();
            if (topBorder == null) {
                topBorder = new Border();
                borders.setTop(topBorder);
            }
            topBorder.setStyle(borderStyles[0].name());
            this.dirtyFields.add("userEnteredFormat.borders.top.style");
        }
        if (borderStyles[1] != null) {
            Border rightBorder = borders.getRight();
            if (rightBorder == null) {
                rightBorder = new Border();
                borders.setRight(rightBorder);
            }
            rightBorder.setStyle(borderStyles[1].name());
            this.dirtyFields.add("userEnteredFormat.borders.right.style");
        }
        if (borderStyles[2] != null) {
            Border bottomBorder = borders.getBottom();
            if (bottomBorder == null) {
                bottomBorder = new Border();
                borders.setBottom(bottomBorder);
            }
            bottomBorder.setStyle(borderStyles[2].name());
            this.dirtyFields.add("userEnteredFormat.borders.bottom.style");
        }
        if (borderStyles[3] != null) {
            Border leftBorder = borders.getLeft();
            if (leftBorder == null) {
                leftBorder = new Border();
                borders.setLeft(leftBorder);
            }
            leftBorder.setStyle(borderStyles[3].name());
            this.dirtyFields.add("userEnteredFormat.borders.left.style");
        }
        return this;
    }

    public BorderStyle[] getBorders() {
        BorderStyle[] borderStyles = new BorderStyle[4];
        Borders borders = this.cellFormat.getBorders();
        if (borders != null) {
            if (borders.getTop() != null && borders.getTop().getStyle() != null) {
                borderStyles[0] = BorderStyle.valueOf(borders.getTop().getStyle());
            }
            if (borders.getRight() != null && borders.getRight().getStyle() != null) {
                borderStyles[1] = BorderStyle.valueOf(borders.getRight().getStyle());
            }
            if (borders.getBottom() != null && borders.getBottom().getStyle() != null) {
                borderStyles[2] = BorderStyle.valueOf(borders.getBottom().getStyle());
            }
            if (borders.getLeft() != null && borders.getLeft().getStyle() != null) {
                borderStyles[3] = BorderStyle.valueOf(borders.getLeft().getStyle());
            }
        }
        return borderStyles;
    }

    public CellStyle borderColors(java.awt.Color ... colors) {
        java.awt.Color[] colorArray;
        if (colors.length == 4) {
            colorArray = colors;
        } else {
            java.awt.Color[] colorArray2 = new java.awt.Color[4];
            colorArray2[0] = colors[0];
            colorArray2[1] = colors[0];
            colorArray2[2] = colors[0];
            colorArray = colorArray2;
            colorArray2[3] = colors[0];
        }
        java.awt.Color[] borderColors = colorArray;
        Borders borders = this.cellFormat.getBorders();
        if (borders == null) {
            borders = new Borders();
            this.cellFormat.setBorders(borders);
        }
        if (borderColors[0] != null) {
            Border topBorder = borders.getTop();
            if (topBorder == null) {
                topBorder = new Border();
                borders.setTop(topBorder);
            }
            topBorder.setColor(this.toGoogleColor(borderColors[0]));
            this.dirtyFields.add("userEnteredFormat.borders.top.color");
        }
        if (borderColors[1] != null) {
            Border rightBorder = borders.getRight();
            if (rightBorder == null) {
                rightBorder = new Border();
                borders.setRight(rightBorder);
            }
            rightBorder.setColor(this.toGoogleColor(borderColors[1]));
            this.dirtyFields.add("userEnteredFormat.borders.right.color");
        }
        if (borderColors[2] != null) {
            Border bottomBorder = borders.getBottom();
            if (bottomBorder == null) {
                bottomBorder = new Border();
                borders.setBottom(bottomBorder);
            }
            bottomBorder.setColor(this.toGoogleColor(borderColors[2]));
            this.dirtyFields.add("userEnteredFormat.borders.bottom.color");
        }
        if (borderColors[3] != null) {
            Border leftBorder = borders.getLeft();
            if (leftBorder == null) {
                leftBorder = new Border();
                borders.setLeft(leftBorder);
            }
            leftBorder.setColor(this.toGoogleColor(borderColors[3]));
            this.dirtyFields.add("userEnteredFormat.borders.left.color");
        }
        return this;
    }

    public java.awt.Color[] getBorderColors() {
        java.awt.Color[] borderColors = new java.awt.Color[4];
        Borders borders = this.cellFormat.getBorders();
        if (borders != null) {
            Color c;
            if (borders.getTop() != null && borders.getTop().getColor() != null) {
                c = borders.getTop().getColor();
                borderColors[0] = new java.awt.Color(c.getRed().floatValue(), c.getGreen().floatValue(), c.getBlue().floatValue(), c.getAlpha().floatValue());
            }
            if (borders.getRight() != null && borders.getRight().getColor() != null) {
                c = borders.getRight().getColor();
                borderColors[1] = new java.awt.Color(c.getRed().floatValue(), c.getGreen().floatValue(), c.getBlue().floatValue(), c.getAlpha().floatValue());
            }
            if (borders.getBottom() != null && borders.getBottom().getColor() != null) {
                c = borders.getBottom().getColor();
                borderColors[2] = new java.awt.Color(c.getRed().floatValue(), c.getGreen().floatValue(), c.getBlue().floatValue(), c.getAlpha().floatValue());
            }
            if (borders.getLeft() != null && borders.getLeft().getColor() != null) {
                c = borders.getLeft().getColor();
                borderColors[3] = new java.awt.Color(c.getRed().floatValue(), c.getGreen().floatValue(), c.getBlue().floatValue(), c.getAlpha().floatValue());
            }
        }
        return borderColors;
    }

    public CellStyle padding(int ... padding) {
        int[] nArray;
        if (padding.length == 4) {
            nArray = padding;
        } else {
            int[] nArray2 = new int[4];
            nArray2[0] = padding[0];
            nArray2[1] = padding[0];
            nArray2[2] = padding[0];
            nArray = nArray2;
            nArray2[3] = padding[0];
        }
        int[] paddings = nArray;
        Padding cellPadding = this.cellFormat.getPadding();
        if (cellPadding == null) {
            cellPadding = new Padding();
            this.cellFormat.setPadding(cellPadding);
        }
        cellPadding.setTop(Integer.valueOf(paddings[0]));
        cellPadding.setRight(Integer.valueOf(paddings[1]));
        cellPadding.setBottom(Integer.valueOf(paddings[2]));
        cellPadding.setLeft(Integer.valueOf(paddings[3]));
        this.dirtyFields.add("userEnteredFormat.padding");
        return this;
    }

    public Integer[] getPadding() {
        Integer[] padding = new Integer[4];
        Padding cellPadding = this.cellFormat.getPadding();
        if (cellPadding != null) {
            padding[0] = cellPadding.getTop();
            padding[1] = cellPadding.getRight();
            padding[2] = cellPadding.getBottom();
            padding[3] = cellPadding.getLeft();
        }
        return padding;
    }

    public CellFormat getCellFormat() {
        return this.cellFormat;
    }

    public void apply() {
        if (this.cell != null && !this.dirtyFields.isEmpty()) {
            this.applyTo(this.cell, false);
        }
    }

    public void applyTo(Cell cell, boolean updateAll) {
        if (cell != null && (updateAll || !this.dirtyFields.isEmpty())) {
            List<String> fieldsToUpdate = updateAll ? Collections.singletonList("userEnteredFormat") : this.dirtyFields;
            cell.getDocument().batchUpdate(r -> {
                CellData gCell = cell.getGCell();
                gCell.setUserEnteredFormat(this.cellFormat);
                r.addUpdateCellRequest(gCell, cell.getRowIndex(), cell.getColumnIndex(), cell.getSheet().getId(), fieldsToUpdate);
            });
            this.dirtyFields.clear();
            this.cellFormat = this.cellFormat.clone();
            this.cell = cell;
        }
    }

    private Color toGoogleColor(java.awt.Color color) {
        return new Color().setRed(Float.valueOf((float)color.getRed() / 255.0f)).setGreen(Float.valueOf((float)color.getGreen() / 255.0f)).setBlue(Float.valueOf((float)color.getBlue() / 255.0f)).setAlpha(Float.valueOf((float)color.getAlpha() / 255.0f));
    }
}

