/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellRef {
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("(\\$?[A-Z]+)?(\\$?[0-9]+)?", 2);
    private String sheetName;
    private int rowIndex = -1;
    private int colIndex = -1;
    private boolean isRowAbs = false;
    private boolean isColAbs = false;
    private String ref;
    private String rowColRef;

    public CellRef(String cellRef) {
        if (cellRef.toUpperCase().contains("#REF!")) {
            throw new IllegalArgumentException("Cell reference invalid: " + cellRef);
        }
        CellRefParts parts = this.separateRefParts(cellRef);
        this.sheetName = parts.sheetName;
        String colRef = parts.colRef;
        boolean bl = this.isColAbs = colRef.length() > 0 && colRef.charAt(0) == '$';
        if (this.isColAbs) {
            colRef = colRef.substring(1);
        }
        this.colIndex = colRef.length() == 0 ? -1 : this.convertColStringToIndex(colRef);
        String rowRef = parts.rowRef;
        boolean bl2 = this.isRowAbs = rowRef.length() > 0 && rowRef.charAt(0) == '$';
        if (this.isRowAbs) {
            rowRef = rowRef.substring(1);
        }
        this.rowIndex = rowRef.length() == 0 ? -1 : Integer.parseInt(rowRef) - 1;
    }

    public CellRef(int rowIndex, int colIndex) {
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
    }

    public CellRef(String sheetName, int rowIndex, int colIndex) {
        this.sheetName = sheetName;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
    }

    public CellRef(String sheetName, int rowIndex, int colIndex, boolean isRowAbs, boolean isColAbs) {
        this.sheetName = sheetName;
        this.rowIndex = rowIndex;
        this.colIndex = colIndex;
        this.isRowAbs = isRowAbs;
        this.isColAbs = isColAbs;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        if (!Objects.equals(this.sheetName, sheetName)) {
            this.sheetName = sheetName;
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getRow() {
        return this.rowIndex;
    }

    public void setRow(int rowIndex) {
        if (this.rowIndex != rowIndex) {
            this.rowIndex = rowIndex;
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getCol() {
        return this.colIndex;
    }

    public void setCol(int colIndex) {
        if (this.colIndex != colIndex) {
            this.colIndex = colIndex;
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public boolean isRowAbsolute() {
        return this.isRowAbs;
    }

    public void setRowAbsolute(boolean rowAbs) {
        if (this.isRowAbs != rowAbs) {
            this.isRowAbs = rowAbs;
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public boolean isColAbsolute() {
        return this.isColAbs;
    }

    public void setColAbsolute(boolean colAbs) {
        if (this.isColAbs != colAbs) {
            this.isColAbs = colAbs;
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public String formatAsString() {
        if (this.ref == null) {
            this.ref = this.formatAsString(true);
        }
        return this.ref;
    }

    public String formatAsString(boolean includeSheetName) {
        StringBuilder sb = new StringBuilder(32);
        if (includeSheetName && this.sheetName != null) {
            this.appendFormattedSheetName(sb, this.sheetName);
            sb.append('!');
        }
        this.appendCellReference(sb);
        return sb.toString();
    }

    public String formatAsRowColString() {
        if (this.rowColRef == null) {
            this.rowColRef = this.formatAsRowColString(true);
        }
        return this.rowColRef;
    }

    public String formatAsRowColString(boolean includeSheetName) {
        StringBuilder sb = new StringBuilder(32);
        if (includeSheetName && this.sheetName != null) {
            this.appendFormattedSheetName(sb, this.sheetName);
            sb.append('!');
        }
        if (this.rowIndex >= 0) {
            if (this.isRowAbs) {
                sb.append('$');
            }
            sb.append("R").append(this.rowIndex + 1);
        }
        if (this.colIndex >= 0) {
            if (this.isColAbs) {
                sb.append('$');
            }
            sb.append("C").append(this.colIndex + 1);
        }
        return sb.toString();
    }

    public boolean isSheetNameDefined() {
        return this.sheetName != null && this.sheetName.length() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellRef)) {
            return false;
        }
        CellRef cellRef = (CellRef)o;
        return this.rowIndex == cellRef.rowIndex && this.colIndex == cellRef.colIndex && this.isRowAbs == cellRef.isRowAbs && this.isColAbs == cellRef.isColAbs && Objects.equals(this.sheetName, cellRef.sheetName);
    }

    public int hashCode() {
        return Objects.hash(this.sheetName, this.rowIndex, this.colIndex, this.isRowAbs, this.isColAbs);
    }

    public String toString() {
        return this.formatAsString();
    }

    void appendCellReference(StringBuilder sb) {
        if (this.colIndex != -1) {
            if (this.isColAbs) {
                sb.append('$');
            }
            sb.append(this.convertNumToColString(this.colIndex));
        }
        if (this.rowIndex != -1) {
            if (this.isRowAbs) {
                sb.append('$');
            }
            sb.append(this.rowIndex + 1);
        }
    }

    private void appendFormattedSheetName(Appendable out, String rawSheetName) {
        try {
            if (this.needsDelimitingForSheetName(rawSheetName)) {
                out.append('\'');
                this.appendAndEscape(out, rawSheetName);
                out.append('\'');
            } else {
                this.appendAndEscape(out, rawSheetName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean needsDelimitingForSheetName(String rawSheetName) {
        if (rawSheetName == null) {
            return false;
        }
        int len = rawSheetName.length();
        if (len < 1) {
            return false;
        }
        if (Character.isDigit(rawSheetName.charAt(0))) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            char ch = rawSheetName.charAt(i);
            if (!this.isSpecialChar(ch)) continue;
            return true;
        }
        if (Character.isLetter(rawSheetName.charAt(0)) && Character.isDigit(rawSheetName.charAt(len - 1)) && this.nameLooksLikePlainCellReference(rawSheetName)) {
            return true;
        }
        return CellRef.nameLooksLikeBooleanLiteral(rawSheetName);
    }

    private boolean isSpecialChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': {
                throw new RuntimeException(String.format("Illegal character (0x%s) found in sheet name.", Integer.toHexString(ch)));
            }
            case '.': 
            case '_': {
                return false;
            }
        }
        return true;
    }

    private void appendAndEscape(Appendable sb, String rawSheetName) {
        try {
            if (rawSheetName == null) {
                sb.append("#REF");
                return;
            }
            int len = rawSheetName.length();
            for (int i = 0; i < len; ++i) {
                char ch = rawSheetName.charAt(i);
                if (ch == '\'') {
                    sb.append('\'');
                }
                sb.append(ch);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean nameLooksLikeBooleanLiteral(String rawSheetName) {
        switch (rawSheetName.charAt(0)) {
            case 'T': 
            case 't': {
                return "TRUE".equalsIgnoreCase(rawSheetName);
            }
            case 'F': 
            case 'f': {
                return "FALSE".equalsIgnoreCase(rawSheetName);
            }
        }
        return false;
    }

    private boolean nameLooksLikePlainCellReference(String rawSheetName) {
        Matcher matcher = CELL_REF_PATTERN.matcher(rawSheetName);
        return matcher.matches();
    }

    private int convertColStringToIndex(String ref) {
        int result = 0;
        char[] refs = ref.toUpperCase(Locale.ROOT).toCharArray();
        for (int k = 0; k < refs.length; ++k) {
            char symbol = refs[k];
            if (symbol == '$') {
                if (k == 0) continue;
                throw new IllegalArgumentException("Bad col ref format '" + ref + "'");
            }
            result = result * 26 + symbol - 65 + 1;
        }
        return result - 1;
    }

    public String convertNumToColString(int col) {
        int excelColNum = col + 1;
        StringBuilder colRef = new StringBuilder(2);
        int colRemain = excelColNum;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            char colChar = (char)(thisPart + 64);
            colRef.insert(0, colChar);
        }
        return colRef.toString();
    }

    private CellRefParts separateRefParts(String reference) {
        int plingPos = reference.lastIndexOf(33);
        String sheetName = CellRef.parseSheetName(reference, plingPos);
        String cell = reference.substring(plingPos + 1).toUpperCase(Locale.ROOT);
        Matcher matcher = CELL_REF_PATTERN.matcher(cell);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid CellReference: " + reference);
        }
        String col = matcher.group(1);
        String row = matcher.group(2);
        return new CellRefParts(sheetName, row, col);
    }

    private static String parseSheetName(String reference, int indexOfSheetNameDelimiter) {
        boolean isQuoted;
        if (indexOfSheetNameDelimiter < 0) {
            return null;
        }
        boolean bl = isQuoted = reference.charAt(0) == '\'';
        if (!isQuoted) {
            if (!reference.contains(" ")) {
                return reference.substring(0, indexOfSheetNameDelimiter);
            }
            throw new IllegalArgumentException(String.format("Sheet names containing spaces must be quoted: (%s)", reference));
        }
        int lastQuotePos = indexOfSheetNameDelimiter - 1;
        if (reference.charAt(lastQuotePos) != '\'') {
            throw new IllegalArgumentException(String.format("Mismatched quotes: (%s)", reference));
        }
        StringBuilder sb = new StringBuilder(indexOfSheetNameDelimiter);
        for (int i = 1; i < lastQuotePos; ++i) {
            char ch = reference.charAt(i);
            if (ch != '\'') {
                sb.append(ch);
                continue;
            }
            if (i + 1 >= lastQuotePos || reference.charAt(i + 1) != '\'') {
                throw new IllegalArgumentException(String.format("Bad sheet name quote escaping: (%s)", reference));
            }
            ++i;
            sb.append(ch);
        }
        return sb.toString();
    }

    private static final class CellRefParts {
        final String sheetName;
        final String rowRef;
        final String colRef;

        CellRefParts(String sheetName, String rowRef, String colRef) {
            this.sheetName = sheetName;
            this.rowRef = rowRef != null ? rowRef : "";
            this.colRef = colRef != null ? colRef : "";
        }
    }
}

