/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.model.GridRange;
import eu.easyrpa.openframework.google.sheets.CellRef;
import java.util.Objects;

public class CellRange {
    private static final char CELL_DELIMITER = ':';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private static final char SHEET_NAME_DELIMITER = '!';
    private CellRef firstCell;
    private CellRef lastCell;
    private String ref;
    private String rowColRef;

    public CellRange(String rangeRef) {
        String[] parts = this.separateRangeRefs(rangeRef);
        String part0 = parts[0];
        if (parts.length == 1) {
            this.lastCell = this.firstCell = new CellRef(part0);
        } else if (parts.length == 2) {
            String part1 = parts[1];
            this.firstCell = new CellRef(part0);
            this.lastCell = new CellRef(part1);
        } else {
            throw new IllegalArgumentException("Bad range ref '" + rangeRef + "'");
        }
    }

    public CellRange(int firstRow, int firstCol, int lastRow, int lastCol) {
        this.firstCell = new CellRef(firstRow, firstCol);
        this.lastCell = new CellRef(lastRow, lastCol);
    }

    public CellRange(String sheetName, int firstRow, int firstCol, int lastRow, int lastCol) {
        this.firstCell = new CellRef(sheetName, firstRow, firstCol);
        this.lastCell = new CellRef(sheetName, lastRow, lastCol);
    }

    public CellRange(GridRange gridRange) {
        this.firstCell = new CellRef(gridRange.getStartRowIndex(), gridRange.getStartColumnIndex());
        this.lastCell = new CellRef(gridRange.getEndRowIndex() - 1, gridRange.getEndColumnIndex() - 1);
    }

    public String getSheetName() {
        return this.firstCell.getSheetName();
    }

    public void setSheetName(String sheetName) {
        if (!Objects.equals(this.getSheetName(), sheetName)) {
            this.firstCell.setSheetName(sheetName);
            this.lastCell.setSheetName(sheetName);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getFirstRow() {
        return this.firstCell.getRow();
    }

    public void setFirstRow(int rowIndex) {
        if (this.firstCell.getRow() != rowIndex) {
            this.firstCell.setRow(rowIndex);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getFirstCol() {
        return this.firstCell.getCol();
    }

    public void setFirstCol(int colIndex) {
        if (this.firstCell.getCol() != colIndex) {
            this.firstCell.setRow(colIndex);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getLastRow() {
        return this.lastCell.getRow();
    }

    public void setLastRow(int rowIndex) {
        if (this.lastCell.getRow() != rowIndex) {
            this.lastCell.setRow(rowIndex);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getLastCol() {
        return this.lastCell.getCol();
    }

    public void setLastCol(int colIndex) {
        if (this.lastCell.getCol() != colIndex) {
            this.lastCell.setRow(colIndex);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public boolean isFirstRowAbsolute() {
        return this.firstCell.isRowAbsolute();
    }

    public void setFirstRowAbsolute(boolean rowAbs) {
        if (this.firstCell.isRowAbsolute() != rowAbs) {
            this.firstCell.setRowAbsolute(rowAbs);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public boolean isFirstColAbsolute() {
        return this.firstCell.isColAbsolute();
    }

    public void setFirstColAbsolute(boolean colAbs) {
        if (this.firstCell.isColAbsolute() != colAbs) {
            this.firstCell.setColAbsolute(colAbs);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public boolean isLastRowAbsolute() {
        return this.lastCell.isRowAbsolute();
    }

    public void setLastRowAbsolute(boolean rowAbs) {
        if (this.lastCell.isRowAbsolute() != rowAbs) {
            this.lastCell.setRowAbsolute(rowAbs);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public boolean isLastColAbsolute() {
        return this.lastCell.isColAbsolute();
    }

    public void setLastColAbsolute(boolean colAbs) {
        if (this.lastCell.isColAbsolute() != colAbs) {
            this.lastCell.setColAbsolute(colAbs);
            this.ref = null;
            this.rowColRef = null;
        }
    }

    public int getColumnsCount() {
        return this.lastCell.getCol() - this.firstCell.getCol() + 1;
    }

    public int getRowsCount() {
        return this.lastCell.getRow() - this.firstCell.getRow() + 1;
    }

    public String formatAsString() {
        if (this.ref == null) {
            StringBuilder sb = new StringBuilder(32);
            sb.append(this.firstCell.formatAsString());
            if (!this.firstCell.equals(this.lastCell)) {
                sb.append(':');
                if (this.lastCell.getSheetName() == null) {
                    sb.append(this.lastCell.formatAsString());
                } else {
                    this.lastCell.appendCellReference(sb);
                }
            }
            return sb.toString();
        }
        return this.ref;
    }

    public String formatAsRowColString() {
        if (this.rowColRef == null) {
            this.rowColRef = this.firstCell.equals(this.lastCell) ? this.firstCell.formatAsRowColString() : this.firstCell.formatAsRowColString() + ':' + this.lastCell.formatAsRowColString(false);
        }
        return this.rowColRef;
    }

    public boolean isSheetNameDefined() {
        String sheetName = this.getSheetName();
        return sheetName != null && sheetName.length() > 0;
    }

    public boolean isInRange(int rowInd, int colInd) {
        return this.firstCell.getRow() <= rowInd && rowInd <= this.lastCell.getRow() && this.firstCell.getCol() <= colInd && colInd <= this.lastCell.getCol();
    }

    public boolean isInRange(CellRef ref) {
        return this.isInRange(ref.getRow(), ref.getCol());
    }

    public boolean isInRange(CellRange range) {
        return this.isInRange(range.firstCell.getRow(), range.firstCell.getCol()) && this.isInRange(range.lastCell.getRow(), range.lastCell.getCol());
    }

    public boolean intersects(CellRange other) {
        return this.firstCell.getRow() <= other.lastCell.getRow() && this.firstCell.getCol() <= other.lastCell.getCol() && other.firstCell.getRow() <= this.lastCell.getRow() && other.firstCell.getCol() <= this.lastCell.getCol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CellRange)) {
            return false;
        }
        CellRange cellRange = (CellRange)o;
        return Objects.equals(this.firstCell, cellRange.firstCell) && Objects.equals(this.lastCell, cellRange.lastCell);
    }

    public int hashCode() {
        return Objects.hash(this.firstCell, this.lastCell);
    }

    public String toString() {
        return this.formatAsString();
    }

    private String[] separateRangeRefs(String reference) {
        int len = reference.length();
        int delimiterPos = -1;
        boolean insideDelimitedName = false;
        block4: for (int i = 0; i < len; ++i) {
            switch (reference.charAt(i)) {
                case '\'': {
                    if (!insideDelimitedName) {
                        insideDelimitedName = true;
                        continue block4;
                    }
                    if (i >= len - 1) {
                        throw new IllegalArgumentException(String.format("Range reference '%s' ends with special name delimiter '%s'", reference, Character.valueOf('\'')));
                    }
                    if (reference.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    insideDelimitedName = false;
                    continue block4;
                }
                case ':': {
                    if (insideDelimitedName) continue block4;
                    if (delimiterPos >= 0) {
                        throw new IllegalArgumentException(String.format("More than one cell delimiter ':' appears in range reference '%s'", reference));
                    }
                    delimiterPos = i;
                }
            }
        }
        if (delimiterPos < 0) {
            return new String[]{reference};
        }
        String partA = reference.substring(0, delimiterPos);
        String partB = reference.substring(delimiterPos + 1);
        if (partB.indexOf(33) >= 0) {
            throw new RuntimeException(String.format("Unexpected ! in second cell reference of '%s'", reference));
        }
        int plingPos = partA.lastIndexOf(33);
        if (plingPos < 0) {
            return new String[]{partA, partB};
        }
        String sheetName = partA.substring(0, plingPos + 1);
        return new String[]{partA, sheetName + partB};
    }
}

