/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.google.sheets;

import com.google.api.services.sheets.v4.model.CellData;
import com.google.api.services.sheets.v4.model.CellFormat;
import com.google.api.services.sheets.v4.model.ExtendedValue;
import com.google.api.services.sheets.v4.model.GridData;
import com.google.api.services.sheets.v4.model.NumberFormat;
import com.google.api.services.sheets.v4.model.RowData;
import eu.easyrpa.openframework.google.sheets.CellRange;
import eu.easyrpa.openframework.google.sheets.CellRef;
import eu.easyrpa.openframework.google.sheets.CellStyle;
import eu.easyrpa.openframework.google.sheets.Sheet;
import eu.easyrpa.openframework.google.sheets.SpreadsheetDocument;
import eu.easyrpa.openframework.google.sheets.constants.NumberFormats;
import eu.easyrpa.openframework.google.sheets.utils.SpreadsheetDateUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Cell {
    private Sheet parent;
    private int rowIndex;
    private int columnIndex;

    protected Cell(Sheet parent, int rowIndex, int columnIndex) {
        this.parent = parent;
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    public SpreadsheetDocument getDocument() {
        return this.parent.getDocument();
    }

    public Sheet getSheet() {
        return this.parent;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public CellRef getReference() {
        return new CellRef(this.rowIndex, this.columnIndex);
    }

    public CellStyle getStyle() {
        return new CellStyle(this);
    }

    public void setStyle(CellStyle newStyle) {
        newStyle.applyTo(this, true);
    }

    public Object getValue() {
        return this.getValue(Object.class);
    }

    public <T> T getValue(Class<T> valueType) {
        Cell thisCell = this.getMergedRegionCell();
        if (thisCell == null) {
            thisCell = this;
        }
        if (String.class.isAssignableFrom(valueType)) {
            return (T)thisCell.getValueAsString();
        }
        if (Number.class.isAssignableFrom(valueType)) {
            return thisCell.getValueAsNumeric(valueType);
        }
        return (T)thisCell.getTypedValue();
    }

    public void setValue(Object value) {
        this.getDocument().batchUpdate(r -> {
            CellData gCell;
            Cell thisCell = this.getMergedRegionCell();
            if (thisCell == null) {
                thisCell = this;
            }
            if ((gCell = thisCell.getGCell()) == null) {
                return;
            }
            ArrayList<String> fieldsToUpdate = new ArrayList<String>();
            fieldsToUpdate.add("userEnteredValue");
            if (value == null) {
                gCell.setUserEnteredValue(new ExtendedValue().setStringValue(""));
            } else if (value instanceof Date || value instanceof LocalDate || value instanceof LocalDateTime) {
                NumberFormats dateFormat;
                double date;
                if (value instanceof LocalDateTime) {
                    date = SpreadsheetDateUtil.getSpreadsheetDate((LocalDateTime)value);
                    dateFormat = NumberFormats.DATE_TIME;
                } else if (value instanceof LocalDate) {
                    date = SpreadsheetDateUtil.getSpreadsheetDate((LocalDate)value);
                    dateFormat = NumberFormats.DATE;
                } else {
                    date = SpreadsheetDateUtil.getSpreadsheetDate((Date)value);
                    dateFormat = NumberFormats.DATE_TIME;
                }
                fieldsToUpdate.addAll(this.checkAndSetNumberFormat(gCell, dateFormat));
                gCell.setUserEnteredValue(new ExtendedValue().setNumberValue(Double.valueOf(date)));
            } else if (value instanceof Number) {
                fieldsToUpdate.addAll(this.checkAndSetNumberFormat(gCell, NumberFormats.NUMBER));
                gCell.setUserEnteredValue(new ExtendedValue().setNumberValue(Double.valueOf(((Number)value).doubleValue())));
            } else if (value instanceof Boolean) {
                gCell.setUserEnteredValue(new ExtendedValue().setBoolValue((Boolean)value));
            } else if (value instanceof String && value.toString().startsWith("=")) {
                gCell.setUserEnteredValue(new ExtendedValue().setFormulaValue((String)value));
            } else {
                gCell.setUserEnteredValue(new ExtendedValue().setStringValue(value.toString()));
            }
            r.addUpdateCellRequest(gCell, thisCell.rowIndex, thisCell.columnIndex, this.getSheet().getId(), fieldsToUpdate);
        });
    }

    public boolean isEmpty() {
        CellData gCell;
        Cell thisCell = this.getMergedRegionCell();
        if (thisCell == null) {
            thisCell = this;
        }
        if ((gCell = thisCell.getGCell()) == null) {
            return true;
        }
        return gCell.getFormattedValue() == null || gCell.getFormattedValue().isEmpty();
    }

    public boolean hasFormula() {
        CellData gCell;
        Cell thisCell = this.getMergedRegionCell();
        if (thisCell == null) {
            thisCell = this;
        }
        return (gCell = thisCell.getGCell()) != null && gCell.getUserEnteredValue().getFormulaValue() != null;
    }

    public String getFormula() {
        CellData gCell;
        Cell thisCell = this.getMergedRegionCell();
        if (thisCell == null) {
            thisCell = this;
        }
        return (gCell = thisCell.getGCell()) != null ? gCell.getUserEnteredValue().getFormulaValue() : null;
    }

    public void setFormula(String newCellFormula) {
        CellData gCell;
        Cell thisCell = this.getMergedRegionCell();
        if (thisCell == null) {
            thisCell = this;
        }
        if ((gCell = thisCell.getGCell()) != null) {
            Cell cell = thisCell;
            String formula = newCellFormula != null && !newCellFormula.startsWith("=") ? "=" + newCellFormula : newCellFormula;
            this.getDocument().batchUpdate(r -> {
                gCell.setUserEnteredValue(new ExtendedValue().setFormulaValue(formula));
                r.addUpdateCellRequest(gCell, cell.rowIndex, cell.columnIndex, this.getSheet().getId(), "userEnteredValue");
            });
        }
    }

    public boolean isMerged() {
        if (this.parent.getGSheet().getMerges() == null) {
            return false;
        }
        return this.parent.getMergedRegions().stream().anyMatch(r -> r.isInRange(this.rowIndex, this.columnIndex));
    }

    public CellRange getMergedRegion() {
        if (this.parent.getGSheet().getMerges() == null) {
            return null;
        }
        return this.parent.getMergedRegions().stream().filter(r -> r.isInRange(this.rowIndex, this.columnIndex)).findFirst().orElse(null);
    }

    public Cell getMergedRegionCell() {
        CellRange region = this.getMergedRegion();
        if (region != null) {
            if (region.getFirstRow() == this.rowIndex && region.getFirstCol() == this.columnIndex) {
                return this;
            }
            return new Cell(this.getSheet(), region.getFirstRow(), region.getFirstCol());
        }
        return null;
    }

    public CellData getGCell() {
        for (GridData gridData : this.parent.getGSheet().getData()) {
            int startColumn;
            if (gridData.getRowData() == null || gridData.getRowData().isEmpty()) continue;
            int startRow = gridData.getStartRow() != null ? gridData.getStartRow() : 0;
            int n = startColumn = gridData.getStartColumn() != null ? gridData.getStartColumn() : 0;
            if (this.rowIndex < startRow || this.rowIndex >= startRow + gridData.getRowData().size()) continue;
            RowData gRow = (RowData)gridData.getRowData().get(this.rowIndex - startRow);
            int cellIndex = this.columnIndex - startColumn;
            return gRow.getValues() != null && cellIndex >= 0 && cellIndex < gRow.getValues().size() ? (CellData)gRow.getValues().get(cellIndex) : null;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.parent.getId() == cell.parent.getId() && this.rowIndex == cell.rowIndex && this.columnIndex == cell.columnIndex;
    }

    public int hashCode() {
        return Objects.hash(this.parent.getId(), this.rowIndex, this.columnIndex);
    }

    private Object getTypedValue() {
        NumberFormat numberFormat;
        CellData gCell = this.getGCell();
        if (gCell == null || gCell.size() == 0) {
            return null;
        }
        ExtendedValue extendedValue = gCell.getEffectiveValue();
        Object value = extendedValue != null ? (extendedValue.getNumberValue() != null ? ((numberFormat = gCell.getEffectiveFormat().getNumberFormat()) != null && (NumberFormats.DATE_TIME.name().equals(numberFormat.getType()) || NumberFormats.DATE.name().equals(numberFormat.getType()) || NumberFormats.TIME.name().equals(numberFormat.getType())) ? SpreadsheetDateUtil.getLocalDateTime(extendedValue.getNumberValue()) : extendedValue.getNumberValue()) : (extendedValue.getBoolValue() != null ? extendedValue.getBoolValue() : (extendedValue.getErrorValue() != null ? extendedValue.getErrorValue().getMessage() : (extendedValue.getStringValue() != null ? extendedValue.getStringValue() : extendedValue.toString())))) : "";
        return value;
    }

    private String getValueAsString() {
        CellData gCell = this.getGCell();
        if (gCell == null || gCell.size() == 0) {
            return "";
        }
        return gCell.getFormattedValue();
    }

    private <T> T getValueAsNumeric(Class<T> numberClass) {
        CellData gCell = this.getGCell();
        if (gCell == null || gCell.size() == 0) {
            return null;
        }
        if (gCell.getEffectiveValue() != null && gCell.getEffectiveValue().getNumberValue() != null) {
            Double value = gCell.getEffectiveValue().getNumberValue();
            try {
                if (Byte.class.isAssignableFrom(numberClass)) {
                    return (T)Byte.valueOf(value.byteValue());
                }
                if (Short.class.isAssignableFrom(numberClass)) {
                    return (T)Short.valueOf(value.shortValue());
                }
                if (Integer.class.isAssignableFrom(numberClass)) {
                    return (T)Integer.valueOf(value.intValue());
                }
                if (Long.class.isAssignableFrom(numberClass)) {
                    return (T)Long.valueOf(value.longValue());
                }
                if (Float.class.isAssignableFrom(numberClass)) {
                    return (T)Float.valueOf(value.floatValue());
                }
                if (Double.class.isAssignableFrom(numberClass)) {
                    return (T)value;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (gCell.getFormattedValue() != null) {
            String value = gCell.getFormattedValue();
            try {
                if (Byte.class.isAssignableFrom(numberClass)) {
                    return (T)Byte.valueOf(value);
                }
                if (Short.class.isAssignableFrom(numberClass)) {
                    return (T)Short.valueOf(value);
                }
                if (Integer.class.isAssignableFrom(numberClass)) {
                    return (T)Integer.valueOf(value);
                }
                if (Long.class.isAssignableFrom(numberClass)) {
                    return (T)Long.valueOf(value);
                }
                if (Float.class.isAssignableFrom(numberClass)) {
                    return (T)Float.valueOf(value);
                }
                if (Double.class.isAssignableFrom(numberClass)) {
                    return (T)Double.valueOf(value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private List<String> checkAndSetNumberFormat(CellData gCell, NumberFormats formatToSet) {
        NumberFormat format;
        NumberFormat numberFormat = format = gCell.getUserEnteredFormat() != null ? gCell.getUserEnteredFormat().getNumberFormat() : null;
        if (format == null || !formatToSet.name().equals(format.getType())) {
            if (format == null) {
                format = new NumberFormat();
                if (gCell.getUserEnteredFormat() == null) {
                    gCell.setUserEnteredFormat(new CellFormat());
                }
                gCell.getUserEnteredFormat().setNumberFormat(format);
            }
            format.setType(formatToSet.name());
            format.setPattern("");
            return Arrays.asList("userEnteredFormat.numberFormat.type", "userEnteredFormat.numberFormat.pattern");
        }
        return Collections.emptyList();
    }
}

