/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.utils;

import eu.easyrpa.openframework.email.EmailMessage;
import eu.easyrpa.openframework.email.exception.EmailMessagingException;
import eu.easyrpa.openframework.email.service.javax.MimeMessageConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.FilenameUtils;

public class EmailParsingUtils {
    public static EmailMessage parseEmlFile(String path) throws FileNotFoundException {
        String extension = FilenameUtils.getExtension((String)path);
        if (extension.equalsIgnoreCase("eml")) {
            return EmailParsingUtils.parseEmlFile(new FileInputStream(new File(path)));
        }
        throw new IllegalArgumentException("Wrong file extension: " + extension + ". Should be a 'eml' file");
    }

    public static EmailMessage parseEmlFile(InputStream source) {
        Session session = Session.getDefaultInstance((Properties)System.getProperties(), null);
        try {
            MimeMessage message = new MimeMessage(session, source);
            MimeMessageConverter converter = new MimeMessageConverter(session);
            return converter.convertToEmailMessage((Message)message);
        }
        catch (MessagingException e) {
            throw new EmailMessagingException(e);
        }
    }
}

