/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.service.javax;

import com.fasterxml.jackson.annotation.JsonIgnore;
import eu.easyrpa.openframework.email.EmailMessage;
import eu.easyrpa.openframework.email.EmailSender;
import eu.easyrpa.openframework.email.exception.EmailMessagingException;
import eu.easyrpa.openframework.email.message.EmailAddress;
import eu.easyrpa.openframework.email.message.EmailAttachment;
import eu.easyrpa.openframework.email.message.EmailBodyPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.UIDFolder;
import javax.mail.internet.MimeMessage;

public class MimeMessageWrapper
extends EmailMessage {
    private static final String CHARSET_KEY = "charset=";
    private static final String MIME_MULTIPART = "multipart";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String MIME_TEXT_HTML = "text/html";
    @JsonIgnore
    private MimeMessage mimeMessage;

    public MimeMessageWrapper(MimeMessage mimeMessage) {
        this.mimeMessage = mimeMessage;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.openFolderAndPerform(1, () -> {
                try {
                    Folder folder = this.mimeMessage.getFolder();
                    return folder instanceof UIDFolder ? String.valueOf(((UIDFolder)folder).getUID((Message)this.mimeMessage)) : null;
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.id;
    }

    @Override
    public Date getDate() {
        if (this.date == null) {
            this.date = this.openFolderAndPerform(1, () -> {
                try {
                    Date messageDate = this.mimeMessage.getReceivedDate();
                    if (messageDate == null) {
                        messageDate = this.mimeMessage.getSentDate();
                    }
                    return messageDate;
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.date;
    }

    @Override
    public String getParentFolder() {
        Folder folder;
        if (this.parentFolder == null && (folder = this.mimeMessage.getFolder()) != null) {
            this.parentFolder = folder.getFullName();
        }
        return this.parentFolder;
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = this.openFolderAndPerform(1, () -> {
                try {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    Enumeration xHeaders = this.mimeMessage.getAllHeaders();
                    while (xHeaders.hasMoreElements()) {
                        Header header = (Header)xHeaders.nextElement();
                        headers.put(header.getName(), header.getValue());
                    }
                    return headers;
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        throw new UnsupportedOperationException("Headers cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage header(String key, String value) {
        throw new UnsupportedOperationException("Headers cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailAddress getSender() {
        if (this.sender == null) {
            super.setSender(this.openFolderAndPerform(1, () -> {
                try {
                    return this.convertToEmailAddress(this.mimeMessage.getSender());
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            }));
        }
        return this.sender;
    }

    @Override
    public void setSender(EmailAddress sender) {
        throw new UnsupportedOperationException("The field 'sender' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public void setSender(String senderAddress) {
        throw new UnsupportedOperationException("The field 'sender' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public String getSenderName() {
        if (this.senderName == null) {
            this.getSender();
        }
        return this.senderName;
    }

    @Override
    public void setSenderName(String senderName) {
        throw new UnsupportedOperationException("The field 'senderName' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailAddress getFrom() {
        if (this.from == null) {
            this.from = this.openFolderAndPerform(1, () -> {
                try {
                    List<EmailAddress> fromAddress = this.convertToEmailAddresses(this.mimeMessage.getFrom());
                    return fromAddress.size() > 0 ? fromAddress.get(0) : null;
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.from;
    }

    @Override
    public void setFrom(EmailAddress from) {
        throw new UnsupportedOperationException("The field 'from' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public void setFrom(String fromAddress) {
        throw new UnsupportedOperationException("The field 'from' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public List<EmailAddress> getRecipients() {
        if (this.recipients == null) {
            this.recipients = this.openFolderAndPerform(1, () -> {
                try {
                    return this.convertToEmailAddresses(this.mimeMessage.getRecipients(Message.RecipientType.TO));
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.recipients;
    }

    @Override
    public void setRecipients(List<EmailAddress> recipientsList) {
        throw new UnsupportedOperationException("The field 'recipients' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage recipients(String ... recipientsSequence) {
        throw new UnsupportedOperationException("The field 'recipients' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public List<EmailAddress> getCcRecipients() {
        if (this.ccRecipients == null) {
            this.ccRecipients = this.openFolderAndPerform(1, () -> {
                try {
                    return this.convertToEmailAddresses(this.mimeMessage.getRecipients(Message.RecipientType.CC));
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.ccRecipients;
    }

    @Override
    public void setCcRecipients(List<EmailAddress> recipientsList) {
        throw new UnsupportedOperationException("The field 'ccRecipients' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage ccRecipients(String ... recipientsSequence) {
        throw new UnsupportedOperationException("The field 'ccRecipients' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public List<EmailAddress> getBccRecipients() {
        if (this.bccRecipients == null) {
            this.bccRecipients = this.openFolderAndPerform(1, () -> {
                try {
                    return this.convertToEmailAddresses(this.mimeMessage.getRecipients(Message.RecipientType.BCC));
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.bccRecipients;
    }

    @Override
    public void setBccRecipients(List<EmailAddress> recipientsList) {
        throw new UnsupportedOperationException("The field 'bccRecipients' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage bccRecipients(String ... recipientsSequence) {
        throw new UnsupportedOperationException("The field 'bccRecipients' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public List<EmailAddress> getReplyTo() {
        if (this.replyTo == null) {
            this.replyTo = this.openFolderAndPerform(1, () -> {
                try {
                    return this.convertToEmailAddresses(this.mimeMessage.getReplyTo());
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.replyTo;
    }

    @Override
    public void setReplyTo(List<EmailAddress> recipientsList) {
        throw new UnsupportedOperationException("The field 'replyTo' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage replyTo(String ... recipientsSequence) {
        throw new UnsupportedOperationException("The field 'replyTo' cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public String getSubject() {
        if (this.subject == null) {
            this.subject = this.openFolderAndPerform(1, () -> {
                try {
                    return this.mimeMessage.getSubject();
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.subject;
    }

    @Override
    public void setSubject(String subject) {
        throw new UnsupportedOperationException("Subject cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public String getCharset() {
        if (this.charset == null) {
            this.charset = this.openFolderAndPerform(1, () -> {
                try {
                    String charset = this.extractCharset((Part)this.mimeMessage);
                    return charset != null ? charset : StandardCharsets.UTF_8.name();
                }
                catch (IOException | MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        throw new UnsupportedOperationException("Body charset cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public List<EmailBodyPart> getBodyParts() {
        if (this.bodyParts == null) {
            this.bodyParts = this.openFolderAndPerform(1, () -> {
                try {
                    return this.extractBodyParts((Part)this.mimeMessage);
                }
                catch (IOException | MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.bodyParts;
    }

    @Override
    public void setBodyParts(List<EmailBodyPart> bodyParts) {
        throw new UnsupportedOperationException("Body cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage text(String text) {
        throw new UnsupportedOperationException("Body cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public EmailMessage html(String html) {
        throw new UnsupportedOperationException("Body cannot be changed for retrieved from mailbox message.");
    }

    @Override
    public List<EmailAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = this.openFolderAndPerform(1, () -> {
                try {
                    return this.extractAttachments((Part)this.mimeMessage);
                }
                catch (IOException | MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return this.attachments;
    }

    @Override
    public void setAttachments(List<EmailAttachment> attachments) {
        throw new UnsupportedOperationException("New files cannot be attached to retrieved from mailbox message.");
    }

    @Override
    public EmailMessage attach(File file) {
        throw new UnsupportedOperationException("New files cannot be attached to retrieved from mailbox message.");
    }

    @Override
    public EmailMessage attach(Path filePath) {
        throw new UnsupportedOperationException("New files cannot be attached to retrieved from mailbox message.");
    }

    @Override
    public EmailMessage attach(String fileName, InputStream fileContent, String mimeType) {
        throw new UnsupportedOperationException("New files cannot be attached to retrieved from mailbox message.");
    }

    @Override
    public boolean isRead() {
        if (this.isRead == null) {
            this.isRead = this.openFolderAndPerform(1, () -> {
                try {
                    return this.mimeMessage.getFlags().contains(Flags.Flag.SEEN);
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
        return super.isRead();
    }

    @Override
    public boolean isUnread() {
        return !this.isRead();
    }

    @Override
    public void setRead(boolean read) {
        if (this.isRead() != read) {
            this.isRead = this.openFolderAndPerform(2, () -> {
                try {
                    this.mimeMessage.setFlag(Flags.Flag.SEEN, read);
                    return read;
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            });
        }
    }

    @Override
    public void send() {
        throw new UnsupportedOperationException("Retrieved from mailbox message cannot be resend.");
    }

    @Override
    public void send(EmailSender emailSender) {
        throw new UnsupportedOperationException("Retrieved from mailbox message cannot be resend.");
    }

    private List<EmailAddress> convertToEmailAddresses(Address[] addresses) {
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
        if (addresses != null) {
            for (Address address : addresses) {
                EmailAddress emailAddress = this.convertToEmailAddress(address);
                if (emailAddress == null) continue;
                emailAddresses.add(emailAddress);
            }
        }
        return emailAddresses;
    }

    private EmailAddress convertToEmailAddress(Address address) {
        return address != null ? new EmailAddress(address.toString()) : null;
    }

    private List<EmailBodyPart> extractBodyParts(Part part) throws MessagingException, IOException {
        Object content;
        ArrayList<EmailBodyPart> result = new ArrayList<EmailBodyPart>();
        String mimeType = part.getContentType().toLowerCase();
        if (mimeType.contains(MIME_MULTIPART)) {
            Multipart multipart = (Multipart)part.getContent();
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart childPart = multipart.getBodyPart(i);
                result.addAll(this.extractBodyParts((Part)childPart));
            }
        } else if (part.getContent() instanceof Part) {
            result.addAll(this.extractBodyParts((Part)part.getContent()));
        } else if (mimeType.contains(MIME_TEXT_PLAIN)) {
            Object content2 = part.getContent();
            if (content2 instanceof String) {
                result.add(new EmailBodyPart((String)content2, MIME_TEXT_PLAIN));
            }
        } else if (mimeType.contains(MIME_TEXT_HTML) && (content = part.getContent()) instanceof String) {
            result.add(new EmailBodyPart((String)content, MIME_TEXT_HTML));
        }
        return result;
    }

    private List<EmailAttachment> extractAttachments(Part part) throws MessagingException, IOException {
        ArrayList<EmailAttachment> result = new ArrayList<EmailAttachment>();
        String mimeType = part.getContentType().toLowerCase();
        String disposition = part.getDisposition();
        if (mimeType.contains(MIME_MULTIPART)) {
            Multipart multipart = (Multipart)part.getContent();
            for (int i = 0; i < multipart.getCount(); ++i) {
                BodyPart childPart = multipart.getBodyPart(i);
                result.addAll(this.extractAttachments((Part)childPart));
            }
        } else if (!mimeType.contains(MIME_TEXT_PLAIN) && !mimeType.contains(MIME_TEXT_HTML) && ("attachment".equalsIgnoreCase(disposition) || "inline".equalsIgnoreCase(disposition))) {
            if (mimeType.contains(";")) {
                mimeType = mimeType.substring(0, mimeType.indexOf(";"));
            }
            result.add(new EmailAttachment(part.getFileName(), part.getInputStream(), mimeType));
        } else if (part.getContent() instanceof Part) {
            result.addAll(this.extractAttachments((Part)part.getContent()));
        }
        return result;
    }

    private String extractCharset(Part part) throws MessagingException, IOException {
        String charset = null;
        String mimeType = part.getContentType().toLowerCase();
        if (mimeType.contains(CHARSET_KEY)) {
            int endOfCharsetSubstring = mimeType.indexOf(";", mimeType.indexOf(CHARSET_KEY));
            charset = endOfCharsetSubstring >= 0 ? mimeType.substring(mimeType.indexOf(CHARSET_KEY) + CHARSET_KEY.length(), endOfCharsetSubstring).trim().toUpperCase() : mimeType.substring(mimeType.indexOf(CHARSET_KEY) + CHARSET_KEY.length()).trim().toUpperCase();
        } else if (mimeType.contains(MIME_MULTIPART)) {
            BodyPart childPart;
            Multipart multipart = (Multipart)part.getContent();
            for (int i = 0; i < multipart.getCount() && (charset = this.extractCharset((Part)(childPart = multipart.getBodyPart(i)))) == null; ++i) {
            }
        } else if (part.getContent() instanceof Part) {
            charset = this.extractCharset((Part)part.getContent());
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T openFolderAndPerform(int mode, Supplier<T> action) {
        try {
            Folder folder = this.mimeMessage.getFolder();
            if (folder.isOpen() && folder.getMode() >= mode) {
                return action.get();
            }
            boolean folderWasOpen = false;
            if (folder.isOpen()) {
                folderWasOpen = true;
                folder.close(false);
            }
            folder.open(mode);
            try {
                T t = action.get();
                return t;
            }
            finally {
                if (!folderWasOpen) {
                    folder.close(false);
                }
            }
        }
        catch (MessagingException e) {
            throw new EmailMessagingException(e);
        }
    }
}

