/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.service.javax;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.mail.imap.IMAPFolder;
import eu.easyrpa.openframework.email.EmailMessage;
import eu.easyrpa.openframework.email.exception.BreakEmailFetchException;
import eu.easyrpa.openframework.email.exception.EmailMessagingException;
import eu.easyrpa.openframework.email.service.EmailServiceSecret;
import eu.easyrpa.openframework.email.service.InboundEmailProtocol;
import eu.easyrpa.openframework.email.service.InboundEmailService;
import eu.easyrpa.openframework.email.service.MessageConverter;
import eu.easyrpa.openframework.email.service.javax.MimeMessageConverter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;

public class ImapPop3EmailService
implements InboundEmailService {
    private static final int DEFAULT_BATCH_SIZE = 10;
    private final String host;
    private final String port;
    private final InboundEmailProtocol protocol;
    private final String user;
    private final String password;
    private Store store;
    private Session session;
    private MessageConverter<Message> messageConverter;
    private int batchSize = 10;

    public ImapPop3EmailService(String server, InboundEmailProtocol protocol, String secret) {
        if (server.contains(":")) {
            String[] parts = server.split(":");
            this.host = parts[0];
            this.port = parts[1];
        } else {
            this.host = server;
            this.port = protocol.getDefaultPort();
        }
        this.protocol = protocol;
        try {
            EmailServiceSecret credentials = (EmailServiceSecret)new ObjectMapper().readValue(secret, EmailServiceSecret.class);
            this.user = credentials.getUser();
            this.password = credentials.getPassword();
        }
        catch (JsonProcessingException e) {
            throw new EmailMessagingException(e);
        }
        this.session = Session.getInstance((Properties)this.getConfigurationFor(protocol), null);
        this.messageConverter = new MimeMessageConverter(this.session);
        try {
            this.store = this.session.getStore(protocol.getProtocolName());
        }
        catch (NoSuchProviderException e) {
            throw new EmailMessagingException(e);
        }
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public InboundEmailProtocol getProtocol() {
        return this.protocol;
    }

    public Session getSession() {
        return this.session;
    }

    public Store getStore() {
        return this.store;
    }

    public MessageConverter<Message> getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter<Message> messageConverter) {
        this.messageConverter = messageConverter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getMessageCount(String folderName) {
        return this.openFolderAndPerform(folderName, 1, folder -> {
            try {
                return folder.getMessageCount();
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public EmailMessage fetchMessage(String messageId) {
        long uid = Long.parseLong(messageId);
        return this.walkOverAllFolders(folder -> {
            try {
                UIDFolder uidFolder = (UIDFolder)folder;
                Message message = uidFolder.getMessageByUID(uid);
                if (message != null) {
                    return this.messageConverter.convertToEmailMessage(message);
                }
                return null;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public List<EmailMessage> fetchMessages(String folderName, Predicate<EmailMessage> isSatisfy) {
        return this.openFolderAndPerform(folderName, 1, folder -> {
            try {
                List<Object> result = new ArrayList();
                if (isSatisfy != null) {
                    int messagesCount = folder.getMessageCount();
                    for (int readMessagesCount = 1; readMessagesCount < messagesCount; readMessagesCount += this.batchSize) {
                        try {
                            int start = readMessagesCount;
                            int end = Math.min(readMessagesCount + this.batchSize - 1, messagesCount);
                            List<EmailMessage> messages = this.messageConverter.convertAllToEmailMessages((Message[])folder.getMessages(start, end));
                            for (EmailMessage message : messages) {
                                try {
                                    if (!isSatisfy.test(message)) continue;
                                    result.add(message);
                                }
                                catch (BreakEmailFetchException e) {
                                    if (e.isIncludeIntoResult()) {
                                        result.add(message);
                                    }
                                    throw e;
                                }
                            }
                            continue;
                        }
                        catch (BreakEmailFetchException e) {
                            break;
                        }
                    }
                } else {
                    result = this.messageConverter.convertAllToEmailMessages((Message[])folder.getMessages());
                }
                return result;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public List<EmailMessage> fetchAllMessages(Predicate<EmailMessage> isSatisfy) {
        ArrayList<EmailMessage> result = new ArrayList<EmailMessage>();
        this.walkOverAllFolders(folder -> {
            try {
                if (isSatisfy != null) {
                    int messagesCount = folder.getMessageCount();
                    for (int readMessagesCount = 1; readMessagesCount < messagesCount; readMessagesCount += this.batchSize) {
                        try {
                            int start = readMessagesCount;
                            int end = Math.min(readMessagesCount + this.batchSize - 1, messagesCount);
                            List<EmailMessage> messages = this.messageConverter.convertAllToEmailMessages((Message[])folder.getMessages(start, end));
                            for (EmailMessage message : messages) {
                                try {
                                    if (!isSatisfy.test(message)) continue;
                                    result.add(message);
                                }
                                catch (BreakEmailFetchException e) {
                                    if (e.isIncludeIntoResult()) {
                                        result.add(message);
                                    }
                                    throw e;
                                }
                            }
                            continue;
                        }
                        catch (BreakEmailFetchException e) {
                            break;
                        }
                    }
                } else {
                    result.addAll(this.messageConverter.convertAllToEmailMessages((Message[])folder.getMessages()));
                }
                return false;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
        return result;
    }

    @Override
    public List<EmailMessage> fetchUnreadMessages(String folderName, boolean markRead) {
        return this.openFolderAndPerform(folderName, markRead ? 2 : 1, folder -> {
            try {
                Flags seen = new Flags(Flags.Flag.SEEN);
                FlagTerm term = new FlagTerm(seen, false);
                Message[] messages = folder.search((SearchTerm)term);
                if (markRead) {
                    folder.setFlags(messages, seen, true);
                }
                return this.messageConverter.convertAllToEmailMessages((Message[])messages);
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<EmailMessage>> waitMessages(String folderName, Predicate<EmailMessage> isSatisfy, Duration timeout, Duration checkInterval) {
        if (timeout == null) {
            throw new IllegalArgumentException("Timeout must be specified.");
        }
        if (checkInterval == null) {
            throw new IllegalArgumentException("Check interval must be specified.");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                long endTime = System.currentTimeMillis() + timeout.toMillis();
                List<EmailMessage> result = this.fetchMessages(folderName, isSatisfy);
                if (!result.isEmpty()) {
                    return result;
                }
                ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
                ScheduledFuture<?> scheduledFuture = ex.scheduleAtFixedRate(() -> {
                    if (result.isEmpty()) {
                        result.addAll(this.openFolderAndPerform(folderName, 1, folder -> {
                            try {
                                List<Object> messages = new ArrayList();
                                Message[] unreadMsgs = folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
                                if (unreadMsgs.length > 0) {
                                    if (isSatisfy != null) {
                                        for (EmailMessage message : this.messageConverter.convertAllToEmailMessages((Message[])unreadMsgs)) {
                                            try {
                                                if (!isSatisfy.test(message)) continue;
                                                messages.add(message);
                                            }
                                            catch (BreakEmailFetchException e) {
                                                if (e.isIncludeIntoResult()) {
                                                    messages.add(message);
                                                }
                                                break;
                                            }
                                        }
                                    } else {
                                        messages = this.messageConverter.convertAllToEmailMessages((Message[])unreadMsgs);
                                    }
                                }
                                return messages;
                            }
                            catch (MessagingException e) {
                                throw new EmailMessagingException(e);
                            }
                        }));
                    }
                }, 0L, checkInterval.toMillis(), TimeUnit.MILLISECONDS);
                do {
                    Thread.sleep(1000L);
                } while (System.currentTimeMillis() <= endTime && result.isEmpty());
                scheduledFuture.cancel(true);
                ex.shutdown();
                return result;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public EmailMessage copyMessage(EmailMessage message, String targetFolder) {
        return this.findMessageAndPerform(message, 1, msg -> {
            try {
                IMAPFolder target = (IMAPFolder)msg.getFolder().getStore().getFolder(targetFolder);
                if (!target.exists()) {
                    throw new EmailMessagingException(String.format("Target folder '%s' does not exist.", targetFolder));
                }
                target.open(2);
                try {
                    Message[] copied = target.addMessages(new Message[]{msg});
                    if (copied.length == 1) {
                        EmailMessage emailMessage = this.messageConverter.convertToEmailMessage(copied[0]);
                        return emailMessage;
                    }
                    EmailMessage emailMessage = null;
                    return emailMessage;
                }
                finally {
                    target.close(false);
                }
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public EmailMessage moveMessage(EmailMessage message, String targetFolder) {
        return this.findMessageAndPerform(message, 2, msg -> {
            try {
                IMAPFolder target = (IMAPFolder)msg.getFolder().getStore().getFolder(targetFolder);
                if (!target.exists()) {
                    throw new EmailMessagingException(String.format("Target folder '%s' does not exist.", targetFolder));
                }
                target.open(2);
                try {
                    Message[] moved = target.addMessages(new Message[]{msg});
                    if (moved.length == 1) {
                        msg.setFlag(Flags.Flag.DELETED, true);
                        msg.getFolder().expunge();
                        EmailMessage emailMessage = this.messageConverter.convertToEmailMessage(moved[0]);
                        return emailMessage;
                    }
                    EmailMessage emailMessage = null;
                    return emailMessage;
                }
                finally {
                    target.close(false);
                }
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public void updateMessage(EmailMessage message) {
        this.findMessageAndPerform(message, 2, msg -> {
            try {
                msg.setFlag(Flags.Flag.SEEN, message.isRead());
                return true;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public void updateMessages(List<EmailMessage> messages) {
        this.findAllMessagesAndPerform(messages, (message, msg) -> {
            try {
                msg.setFlag(Flags.Flag.SEEN, message.isRead());
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
            return false;
        });
    }

    @Override
    public void deleteMessage(EmailMessage message) {
        this.findMessageAndPerform(message, 2, msg -> {
            try {
                Folder folder = msg.getFolder();
                msg.setFlag(Flags.Flag.DELETED, true);
                folder.expunge();
                return true;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public void deleteMessages(List<EmailMessage> messages) {
        this.findAllMessagesAndPerform(messages, (message, msg) -> {
            try {
                msg.setFlag(Flags.Flag.DELETED, true);
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
            return false;
        });
    }

    @Override
    public List<String> listFolders() {
        return this.connectAndPerform(store -> {
            try {
                Folder[] folders = store.getDefaultFolder().list("*");
                return Arrays.stream(folders).map(Folder::getFullName).collect(Collectors.toList());
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public boolean createFolder(String folderName) {
        return this.connectAndPerform(store -> {
            try {
                Folder folder = store.getFolder(folderName);
                if (!folder.exists()) {
                    return folder.create(1);
                }
                return false;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public boolean renameFolder(String folderName, String newFolderName) {
        return this.connectAndPerform(store -> {
            try {
                Folder folder = store.getFolder(folderName);
                Folder newFolder = store.getFolder(newFolderName);
                if (folder.exists() && !newFolder.exists()) {
                    return folder.renameTo(newFolder);
                }
                return false;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    @Override
    public boolean deleteFolder(String folderName) {
        return this.connectAndPerform(store -> {
            try {
                Folder folder = store.getFolder(folderName);
                if (folder.exists()) {
                    return folder.delete(true);
                }
                return false;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    private void findAllMessagesAndPerform(List<EmailMessage> messages, BiFunction<EmailMessage, Message, Boolean> action) {
        Map<String, List<EmailMessage>> groupedMessages = messages.stream().filter(m -> m.getParentFolder() != null && m.getId() != null).collect(Collectors.groupingBy(EmailMessage::getParentFolder));
        for (String folderName : groupedMessages.keySet()) {
            List<EmailMessage> msgGroup;
            boolean res = this.openFolderAndPerform(folderName, 2, arg_0 -> ImapPop3EmailService.lambda$findAllMessagesAndPerform$19(msgGroup = groupedMessages.get(folderName), action, arg_0));
            if (!res) continue;
            return;
        }
    }

    private <T> T findMessageAndPerform(EmailMessage message, int mode, Function<Message, T> action) {
        if (message.getParentFolder() == null) {
            throw new EmailMessagingException("Message does not have a folder specified.");
        }
        if (message.getId() == null) {
            throw new EmailMessagingException("Message does not have a id specified.");
        }
        return (T)this.openFolderAndPerform(message.getParentFolder(), mode, folder -> {
            try {
                UIDFolder uidFolder = (UIDFolder)folder;
                Message msg = uidFolder.getMessageByUID(Long.parseLong(message.getId()));
                if (msg != null) {
                    return action.apply(msg);
                }
                throw new EmailMessagingException(String.format("Message with Id '%s' does not exist in folder '%s'.", message.getId(), message.getParentFolder()));
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    private <T> T openFolderAndPerform(String folderName, int mode, Function<Folder, T> action) {
        return (T)this.connectAndPerform(store -> {
            Object r;
            Folder folder = store.getFolder(folderName);
            if (!folder.exists()) throw new EmailMessagingException(String.format("Folder '%s' does not exist.", folderName));
            folder.open(mode);
            try {
                r = action.apply(folder);
            }
            catch (Throwable throwable) {
                try {
                    folder.close(false);
                    throw throwable;
                }
                catch (MessagingException e) {
                    throw new EmailMessagingException(e);
                }
            }
            folder.close(false);
            return r;
        });
    }

    private <T> T walkOverAllFolders(Function<Folder, T> action) {
        return (T)this.connectAndPerform(store -> {
            try {
                Folder[] folders;
                Folder[] folderArray = folders = store.getDefaultFolder().list("*");
                int n = folderArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Folder folder = folderArray[n2];
                    if (folder.exists() && (folder.getType() & 1) > 0) {
                        folder.open(1);
                        try {
                            Object result = action.apply(folder);
                            if (result != null && (!(result instanceof Boolean) || ((Boolean)result).booleanValue())) {
                                Object r = result;
                                return r;
                            }
                        }
                        finally {
                            folder.close(false);
                        }
                    }
                    ++n2;
                }
                return null;
            }
            catch (MessagingException e) {
                throw new EmailMessagingException(e);
            }
        });
    }

    private <T> T connectAndPerform(Function<Store, T> action) {
        T t;
        try {
            if (!this.store.isConnected()) {
                this.store.connect(this.user, this.password);
            }
            if (!this.store.isConnected()) {
                throw new EmailMessagingException("Email store connection failed.");
            }
            t = action.apply(this.store);
        }
        catch (MessagingException e) {
            throw new EmailMessagingException(e);
        }
        finally {
            try {
                if (this.store.isConnected()) {
                    this.store.close();
                }
            }
            catch (MessagingException messagingException) {}
        }
        return t;
    }

    private Properties getConfigurationFor(InboundEmailProtocol protocol) {
        Properties props = new Properties();
        props.put("mail.store.protocol", protocol.getProtocolName());
        props.put(String.format("mail.%s.host", protocol.getProtocolName()), this.host);
        props.put(String.format("mail.%s.port", protocol.getProtocolName()), this.port);
        if (protocol == InboundEmailProtocol.POP3_OVER_TLS || protocol == InboundEmailProtocol.IMAP_OVER_TLS) {
            props.put(String.format("mail.%s.auth", protocol.getProtocolName()), "true");
            props.put(String.format("mail.%s.starttls.enable", protocol.getProtocolName()), "true");
            props.put(String.format("mail.%s.starttls.required", protocol.getProtocolName()), "true");
        } else if (protocol == InboundEmailProtocol.POP3S || protocol == InboundEmailProtocol.IMAPS) {
            props.put(String.format("mail.%s.auth", protocol.getProtocolName()), "true");
            props.put(String.format("mail.%s.ssl.enable", protocol.getProtocolName()), "true");
            props.put(String.format("mail.%s.socketFactory.class", protocol.getProtocolName()), "javax.net.ssl.SSLSocketFactory");
            props.put(String.format("mail.%s.socketFactory.fallback", protocol.getProtocolName()), "false");
            props.put(String.format("mail.%s.socketFactory.port", protocol.getProtocolName()), this.port);
        }
        return props;
    }

    private static /* synthetic */ Boolean lambda$findAllMessagesAndPerform$19(List msgGroup, BiFunction action, Folder folder) {
        try {
            UIDFolder uidFolder = (UIDFolder)folder;
            for (EmailMessage msg : msgGroup) {
                Message m = uidFolder.getMessageByUID(Long.parseLong(msg.getId()));
                if (m == null || !((Boolean)action.apply(msg, m)).booleanValue()) continue;
                return true;
            }
            return false;
        }
        catch (MessagingException e) {
            throw new EmailMessagingException(e);
        }
    }
}

