/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.service;

import eu.easyrpa.openframework.email.service.InboundEmailProtocol;
import eu.easyrpa.openframework.email.service.InboundEmailService;
import eu.easyrpa.openframework.email.service.OutboundEmailProtocol;
import eu.easyrpa.openframework.email.service.OutboundEmailService;
import eu.easyrpa.openframework.email.service.javax.ImapPop3EmailService;
import eu.easyrpa.openframework.email.service.javax.SmtpEmailService;

public class EmailServiceFactory {
    private static EmailServiceFactory instance;

    private EmailServiceFactory() {
    }

    public static EmailServiceFactory getInstance() {
        if (instance == null) {
            instance = new EmailServiceFactory();
        }
        return instance;
    }

    public InboundEmailService getInboundService(String hostAndPort, InboundEmailProtocol protocol, String secret) {
        if (protocol != null) {
            return new ImapPop3EmailService(hostAndPort, protocol, secret);
        }
        return null;
    }

    public OutboundEmailService getOutboundService(String hostAndPort, OutboundEmailProtocol protocol, String secret) {
        if (protocol != null) {
            return new SmtpEmailService(hostAndPort, protocol, secret);
        }
        return null;
    }
}

