/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.message.templates;

import eu.easyrpa.openframework.email.message.templates.TextTemplate;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class FreeMarkerTemplate
extends TextTemplate {
    private Template template;

    public FreeMarkerTemplate(InputStream inputStream) throws IOException {
        this(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), new HashMap<String, Object>());
    }

    public FreeMarkerTemplate(InputStream inputStream, String charsetName) throws IOException {
        this(IOUtils.toString((InputStream)inputStream, (String)charsetName), new HashMap<String, Object>());
    }

    public FreeMarkerTemplate(String templateText, Map<String, Object> map) throws IOException {
        super(map);
        this.init(templateText);
    }

    @Override
    public String compile() {
        StringWriter writer = new StringWriter();
        this.compileAndWrite(writer);
        return ((Object)writer).toString();
    }

    @Override
    public void compileAndWrite(Writer writer) {
        try {
            this.template.process((Object)this.properties, writer);
            writer.flush();
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException("FreeMarker template compilation has failed.", e);
        }
    }

    private void init(String templateText) throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setClassForTemplateLoading(this.getClass(), "/");
        StringReader reader = new StringReader(templateText);
        this.template = new Template("", (Reader)reader, cfg);
    }
}

