/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import eu.easyrpa.openframework.email.exception.EmailMessagingException;
import eu.easyrpa.openframework.email.message.templates.FreeMarkerTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;

public class EmailBodyPart {
    private static final String FREEMARKER_FILE_EXTENSION = ".ftl";
    public static final String CONTENT_TYPE_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_TEXT_HTML = "text/html";
    private String contentType;
    private String content;

    @JsonCreator
    public EmailBodyPart(@JsonProperty(value="content") String content, @JsonProperty(value="contentType") String contentType) {
        this.contentType = contentType;
        this.setContent(content);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public String getContent(Map<String, Object> properties) {
        try {
            return new FreeMarkerTemplate(this.content, properties).compile();
        }
        catch (Exception e) {
            throw new EmailMessagingException("Email message body compilation has failed.", e);
        }
    }

    public void setContent(String content) {
        if (content != null && content.endsWith(FREEMARKER_FILE_EXTENSION)) {
            try {
                content = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(content), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new EmailMessagingException(String.format("Resource file '%s' not found", content), e);
            }
        }
        this.content = content;
    }

    @JsonIgnore
    public boolean isText() {
        return CONTENT_TYPE_TEXT_PLAIN.equals(this.contentType);
    }

    @JsonIgnore
    public boolean isHtml() {
        return CONTENT_TYPE_TEXT_HTML.equals(this.contentType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailBodyPart)) {
            return false;
        }
        EmailBodyPart part = (EmailBodyPart)o;
        return Objects.equals(this.contentType, part.contentType) && Objects.equals(this.content, part.content);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.content);
    }

    public String toString() {
        return "EmailBodyPart{contentType='" + this.contentType + '\'' + ", content='" + (this.content != null ? this.content.substring(0, Math.min(20, this.content.length())).replaceAll("\\s", " ") + (this.content.length() > 20 ? "..." : "") : "") + '\'' + '}';
    }
}

