/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class EmailAttachment {
    public static final Pattern INLINE_IMAGE_PLACEHOLDER_RE = Pattern.compile("\\[image\\s+\"([\\w.]+)\"\\s+width=(\\d+)\\s+height=(\\d+)]");
    public static final Pattern INLINE_ATTACHMENT_PLACEHOLDER_RE = Pattern.compile("\\[attachment\\s+\"([\\w.]+)\"]");
    private String fileName;
    private String mimeType;
    private byte[] content;

    public static String getImagePlaceholder(String fileName, int width, int height) {
        return String.format("[image \"%s\" width=%s height=%s]", fileName, width, height);
    }

    public static String getAttachmentPlaceholder(String fileName) {
        return String.format("[attachment \"%s\"]", fileName);
    }

    public EmailAttachment(String fileName, InputStream contentSource, String mimeType) {
        this.fileName = fileName;
        try {
            this.content = IOUtils.toByteArray((InputStream)contentSource);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mimeType = mimeType;
    }

    public EmailAttachment(Path path) throws IOException {
        String fileName;
        Path file = path.getFileName();
        this.fileName = fileName = file != null ? file.toString() : "";
        this.content = Files.readAllBytes(path);
        try {
            this.mimeType = Files.probeContentType(Paths.get(fileName.toLowerCase(), new String[0]));
            if (this.mimeType == null) {
                this.mimeType = "text/plain";
            }
        }
        catch (IOException e) {
            this.mimeType = "text/plain";
        }
    }

    @JsonCreator
    public EmailAttachment(@JsonProperty(value="fileName") String fileName, @JsonProperty(value="content") byte[] content, @JsonProperty(value="mimeType") String mimeType) {
        this.fileName = fileName;
        this.content = content;
        this.mimeType = mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    @JsonIgnore
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.content);
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return "EmailAttachment [name=" + this.fileName + ", content size=" + this.content.length + ", mimeType=" + this.mimeType + ']';
    }
}

