/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email.message;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class EmailAddress {
    private String address;
    private String personal;
    private String rfc822Address;

    @JsonCreator
    public EmailAddress(@JsonProperty(value="address") String address, @JsonProperty(value="personal") String personal) {
        try {
            InternetAddress internetAddress = new InternetAddress(address, personal);
            this.address = internetAddress.getAddress();
            this.personal = internetAddress.getPersonal();
            this.rfc822Address = internetAddress.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public EmailAddress(String address) {
        try {
            InternetAddress internetAddress = new InternetAddress(address);
            this.address = internetAddress.getAddress();
            this.personal = internetAddress.getPersonal();
            this.rfc822Address = internetAddress.toString();
        }
        catch (AddressException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        return this.personal;
    }

    public String toHtml() {
        if (this.personal != null) {
            return String.format("<b>%1$s</b> <span>&lt;<a href=\"mailto:%2$s\" target=\"_blank\">%2$s</a>&gt;</span>", this.personal, this.address);
        }
        return String.format("<span>&lt;<a href=\"mailto:%1$s\" target=\"_blank\">%1$s</a>&gt;</span>", this.address);
    }

    public String toString() {
        return this.rfc822Address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmailAddress)) {
            return false;
        }
        EmailAddress that = (EmailAddress)o;
        return Objects.equals(this.address, that.address);
    }

    public int hashCode() {
        return Objects.hash(this.address);
    }
}

