/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.easyrpa.openframework.core.sevices.RPAServicesAccessor;
import eu.easyrpa.openframework.email.EmailMessage;
import eu.easyrpa.openframework.email.service.EmailServiceFactory;
import eu.easyrpa.openframework.email.service.EmailServiceSecret;
import eu.easyrpa.openframework.email.service.OutboundEmailProtocol;
import eu.easyrpa.openframework.email.service.OutboundEmailService;
import javax.inject.Inject;

public class EmailSender {
    private static final OutboundEmailProtocol DEFAULT_OUTBOUND_EMAIL_PROTOCOL = OutboundEmailProtocol.SMTP;
    private RPAServicesAccessor rpaServices;
    private String server;
    private OutboundEmailProtocol protocol;
    private String secret;
    private OutboundEmailService service;

    public EmailSender() {
    }

    @Inject
    public EmailSender(RPAServicesAccessor rpaServices) {
        this.rpaServices = rpaServices;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = this.getConfigParam("outbound.email.server");
        }
        return this.server;
    }

    public void setServer(String emailServerHostAndPort) {
        this.server = emailServerHostAndPort;
        this.service = null;
    }

    public EmailSender server(String emailServerHostAndPort) {
        this.setServer(emailServerHostAndPort);
        return this;
    }

    public OutboundEmailProtocol getProtocol() {
        if (this.protocol == null) {
            String protocolStr = this.getConfigParam("outbound.email.protocol");
            this.protocol = protocolStr != null ? OutboundEmailProtocol.valueOf(protocolStr.toUpperCase()) : DEFAULT_OUTBOUND_EMAIL_PROTOCOL;
        }
        return this.protocol;
    }

    public void setProtocol(OutboundEmailProtocol protocol) {
        this.protocol = protocol;
        this.service = null;
    }

    public EmailSender protocol(OutboundEmailProtocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public EmailSender protocol(String protocol) {
        this.setProtocol(OutboundEmailProtocol.valueOf(protocol.toUpperCase()));
        return this;
    }

    public String getSecret() {
        String secretAlias;
        if (this.secret == null && (secretAlias = this.getConfigParam("outbound.email.secret")) != null) {
            this.secret = (String)this.rpaServices.getSecret(secretAlias, String.class);
        }
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
        this.service = null;
    }

    public EmailSender secret(String secret) {
        this.setSecret(secret);
        return this;
    }

    public EmailSender secret(String userName, String password) {
        try {
            this.setSecret(new ObjectMapper().writeValueAsString((Object)new EmailServiceSecret(userName, password)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public void send(EmailMessage message) {
        message.send(this);
    }

    void sendMessage(EmailMessage message) {
        this.initService();
        message.beforeSend();
        this.service.send(message);
    }

    String getConfigParam(String key) {
        String result = null;
        if (this.rpaServices == null) {
            return null;
        }
        try {
            result = this.rpaServices.getConfigParam(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void initService() {
        if (this.service == null) {
            this.service = EmailServiceFactory.getInstance().getOutboundService(this.getServer(), this.getProtocol(), this.getSecret());
        }
    }
}

