/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.easyrpa.openframework.email.EmailSender;
import eu.easyrpa.openframework.email.message.EmailAddress;
import eu.easyrpa.openframework.email.message.EmailAttachment;
import eu.easyrpa.openframework.email.message.EmailBodyPart;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;

public class EmailMessage {
    public static final String USED_DATE_TME_FORMAT_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    private static final String DEFAULT_EMAIL_TYPE_NAME = "email";
    protected String typeName = "email";
    protected String id;
    @JsonFormat(pattern="MM/dd/yyyy hh:mm:ss a")
    protected Date date;
    protected String parentFolder;
    protected Map<String, String> headers;
    protected EmailAddress sender;
    @JsonIgnore
    protected String senderName;
    protected EmailAddress from;
    protected List<EmailAddress> recipients;
    protected List<EmailAddress> ccRecipients;
    protected List<EmailAddress> bccRecipients;
    protected List<EmailAddress> replyTo;
    protected String subject;
    protected String charset;
    @JsonIgnore
    protected String text;
    @JsonIgnore
    protected String html;
    protected List<EmailBodyPart> bodyParts;
    protected Map<String, Object> bodyProperties = new HashMap<String, Object>();
    protected List<EmailAttachment> attachments;
    protected Boolean isRead;
    @JsonIgnore
    protected EmailMessage forwardedMessage;
    @JsonIgnore
    protected EmailMessage replyOnMessage;
    @JsonIgnore
    protected EmailSender emailSender;

    public EmailMessage() {
    }

    public EmailMessage(String typeName) {
        this.typeName = typeName;
    }

    @Inject
    public EmailMessage(EmailSender emailSender) {
        this.emailSender = emailSender;
    }

    public EmailMessage(String typeName, EmailSender emailSender) {
        this.typeName = typeName;
        this.emailSender = emailSender;
    }

    public String getId() {
        return this.id;
    }

    public String getParentFolder() {
        return this.parentFolder;
    }

    public Date getDate() {
        return this.date;
    }

    @JsonIgnore
    public ZonedDateTime getDateTime() {
        return this.getDate() != null ? ZonedDateTime.ofInstant(this.getDate().toInstant(), ZoneId.systemDefault()) : null;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = new HashMap<String, String>();
        if (headers != null) {
            this.headers.putAll(headers);
        }
    }

    public EmailMessage header(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public EmailAddress getSender() {
        return this.sender;
    }

    public void setSender(String senderAddress) {
        this.sender = senderAddress != null ? new EmailAddress(senderAddress, this.getSenderName()) : null;
    }

    @JsonSetter
    public void setSender(EmailAddress sender) {
        this.sender = sender;
        this.senderName = sender != null ? sender.getPersonal() : null;
    }

    public String getSenderName() {
        if (this.senderName == null) {
            this.senderName = this.getConfigParam("%s.sender.name");
        }
        return this.senderName;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
        if (this.sender != null) {
            this.sender = new EmailAddress(this.sender.getAddress(), this.senderName);
        }
    }

    public EmailMessage senderName(String senderName) {
        this.setSenderName(senderName);
        return this;
    }

    public EmailAddress getFrom() {
        if (this.from == null) {
            String fromAddress = this.getConfigParam("%s.from");
            this.from = fromAddress != null ? new EmailAddress(fromAddress) : null;
        }
        return this.from;
    }

    public void setFrom(String fromAddress) {
        this.from = fromAddress != null ? new EmailAddress(fromAddress) : null;
    }

    @JsonSetter
    public void setFrom(EmailAddress from) {
        this.from = from;
    }

    public EmailMessage from(String fromAddress) {
        this.setFrom(fromAddress);
        return this;
    }

    public List<EmailAddress> getRecipients() {
        String recipientsStr;
        if (this.recipients == null && (recipientsStr = this.getConfigParam("%s.recipients")) != null) {
            this.recipients = new ArrayList<EmailAddress>();
            for (String recipient : recipientsStr.split(";")) {
                if (recipient == null || recipient.trim().isEmpty()) continue;
                this.recipients.add(new EmailAddress(recipient));
            }
        }
        return this.recipients;
    }

    public void setRecipients(List<EmailAddress> recipientsList) {
        this.recipients = new ArrayList<EmailAddress>();
        this.recipients.addAll(recipientsList);
    }

    public EmailMessage recipients(String ... recipientsSequence) {
        this.recipients = new ArrayList<EmailAddress>();
        for (String recipient : recipientsSequence) {
            if (recipient == null || recipient.trim().isEmpty()) continue;
            this.recipients.add(new EmailAddress(recipient));
        }
        return this;
    }

    public EmailMessage excludeFromRecipients(String ... recipientsSequence) {
        if (this.recipients != null) {
            for (String recipient : recipientsSequence) {
                if (recipient == null || recipient.trim().isEmpty() || this.recipients.size() <= 1) continue;
                this.recipients.remove(new EmailAddress(recipient));
            }
        }
        return this;
    }

    public List<EmailAddress> getCcRecipients() {
        if (this.ccRecipients == null) {
            this.ccRecipients = new ArrayList<EmailAddress>();
            String recipientsStr = this.getConfigParam("%s.cc.recipients");
            if (recipientsStr != null) {
                for (String recipient : recipientsStr.split(";")) {
                    if (recipient == null || recipient.trim().isEmpty()) continue;
                    this.ccRecipients.add(new EmailAddress(recipient));
                }
            }
        }
        return this.ccRecipients;
    }

    public void setCcRecipients(List<EmailAddress> recipientsList) {
        this.ccRecipients = new ArrayList<EmailAddress>();
        this.ccRecipients.addAll(recipientsList);
    }

    public EmailMessage ccRecipients(String ... recipientsSequence) {
        this.ccRecipients = new ArrayList<EmailAddress>();
        for (String recipient : recipientsSequence) {
            if (recipient == null || recipient.trim().isEmpty()) continue;
            this.ccRecipients.add(new EmailAddress(recipient));
        }
        return this;
    }

    public EmailMessage excludeFromCcRecipients(String ... recipientsSequence) {
        if (this.ccRecipients != null) {
            for (String recipient : recipientsSequence) {
                if (recipient == null || recipient.trim().isEmpty()) continue;
                this.ccRecipients.remove(new EmailAddress(recipient));
            }
        }
        return this;
    }

    public List<EmailAddress> getBccRecipients() {
        if (this.bccRecipients == null) {
            this.bccRecipients = new ArrayList<EmailAddress>();
            String recipientsStr = this.getConfigParam("%s.bcc.recipients");
            if (recipientsStr != null) {
                for (String recipient : recipientsStr.split(";")) {
                    if (recipient == null || recipient.trim().isEmpty()) continue;
                    this.bccRecipients.add(new EmailAddress(recipient));
                }
            }
        }
        return this.bccRecipients;
    }

    public void setBccRecipients(List<EmailAddress> recipientsList) {
        this.bccRecipients = new ArrayList<EmailAddress>();
        this.bccRecipients.addAll(recipientsList);
    }

    public EmailMessage bccRecipients(String ... recipientsSequence) {
        this.bccRecipients = new ArrayList<EmailAddress>();
        for (String recipient : recipientsSequence) {
            if (recipient == null || recipient.trim().isEmpty()) continue;
            this.bccRecipients.add(new EmailAddress(recipient));
        }
        return this;
    }

    public List<EmailAddress> getReplyTo() {
        if (this.replyTo == null) {
            this.replyTo = new ArrayList<EmailAddress>();
            String recipientsStr = this.getConfigParam("%s.reply.to");
            if (recipientsStr != null) {
                for (String recipient : recipientsStr.split(";")) {
                    if (recipient == null || recipient.trim().isEmpty()) continue;
                    this.replyTo.add(new EmailAddress(recipient));
                }
            }
        }
        return this.replyTo;
    }

    public void setReplyTo(List<EmailAddress> recipientsList) {
        this.replyTo = new ArrayList<EmailAddress>();
        this.replyTo.addAll(recipientsList);
    }

    public EmailMessage replyTo(String ... recipientsSequence) {
        this.replyTo = new ArrayList<EmailAddress>();
        for (String recipient : recipientsSequence) {
            if (recipient == null || recipient.trim().isEmpty()) continue;
            this.replyTo.add(new EmailAddress(recipient));
        }
        return this;
    }

    public String getSubject() {
        if (this.subject == null) {
            this.subject = this.getConfigParam("%s.subject");
        }
        return this.subject != null ? this.subject : "";
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailMessage subject(String subject) {
        this.setSubject(subject);
        return this;
    }

    public String getCharset() {
        if (this.charset == null) {
            this.charset = this.getConfigParam("%s.charset");
        }
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public EmailMessage charset(String charset) {
        this.setCharset(charset);
        return this;
    }

    public List<EmailBodyPart> getBodyParts() {
        if (this.bodyParts == null) {
            this.bodyParts = new ArrayList<EmailBodyPart>();
            String tpl = this.getConfigParam("%s.body.tpl");
            if (tpl != null) {
                this.bodyParts.add(new EmailBodyPart(tpl, "text/html"));
            }
            this.text = null;
            this.html = null;
        }
        return this.bodyParts;
    }

    public void setBodyParts(List<EmailBodyPart> bodyParts) {
        this.bodyParts = new ArrayList<EmailBodyPart>();
        if (bodyParts != null) {
            this.bodyParts.addAll(bodyParts);
        }
        this.text = null;
        this.html = null;
    }

    public EmailMessage text(String text) {
        if (text != null) {
            List<EmailBodyPart> parts = this.getBodyParts();
            List textParts = parts.stream().filter(EmailBodyPart::isText).collect(Collectors.toList());
            if (!textParts.isEmpty()) {
                parts.removeAll(textParts);
            }
            parts.add(new EmailBodyPart(text, "text/plain"));
            this.text = null;
            this.html = null;
        }
        return this;
    }

    public EmailMessage addText(String text) {
        if (text != null) {
            this.getBodyParts().add(new EmailBodyPart(text, "text/plain"));
            this.text = null;
            this.html = null;
        }
        return this;
    }

    public EmailMessage html(String html) {
        if (html != null) {
            List<EmailBodyPart> parts = this.getBodyParts();
            List htmlParts = parts.stream().filter(EmailBodyPart::isHtml).collect(Collectors.toList());
            if (!htmlParts.isEmpty()) {
                parts.removeAll(htmlParts);
            }
            parts.add(new EmailBodyPart(html, "text/html"));
            this.text = null;
            this.html = null;
        }
        return this;
    }

    public EmailMessage addHtml(String html) {
        if (html != null) {
            this.getBodyParts().add(new EmailBodyPart(html, "text/html"));
            this.text = null;
            this.html = null;
        }
        return this;
    }

    public boolean hasHtml() {
        return this.getBodyParts().stream().anyMatch(EmailBodyPart::isHtml);
    }

    public boolean hasText() {
        return this.getBodyParts().stream().anyMatch(EmailBodyPart::isText);
    }

    public String getText() {
        if (this.text == null) {
            if (this.hasText()) {
                this.text = this.getBodyParts().stream().map(part -> part.isText() ? part.getContent(this.bodyProperties) : null).filter(Objects::nonNull).collect(Collectors.joining("\n")).trim();
            } else if (this.hasHtml()) {
                this.text = Jsoup.parse((String)this.getHtml()).text();
            }
        }
        return this.text;
    }

    public String getHtml() {
        if (this.html == null) {
            List<Object> parts = new ArrayList();
            if (this.hasHtml()) {
                parts = this.getBodyParts().stream().map(part -> part.isHtml() ? part.getContent(this.bodyProperties) : null).filter(Objects::nonNull).collect(Collectors.toList());
            } else if (this.hasText()) {
                parts = this.getBodyParts().stream().map(part -> part.isText() ? part.getContent(this.bodyProperties) : null).filter(Objects::nonNull).collect(Collectors.toList());
            }
            String head = parts.stream().map(p -> {
                if (p.contains("<head>")) {
                    return StringUtils.substringBetween((String)p, (String)"<head>", (String)"</head>");
                }
                if (p.contains("<HEAD>")) {
                    return StringUtils.substringBetween((String)p, (String)"<HEAD>", (String)"</HEAD>");
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.joining("\n"));
            String body = parts.stream().map(p -> {
                if (p.contains("<body>")) {
                    return StringUtils.substringBetween((String)p, (String)"<body>", (String)"</body>");
                }
                if (p.contains("<BODY>")) {
                    return StringUtils.substringBetween((String)p, (String)"<BODY>", (String)"</BODY>");
                }
                return p.startsWith("<") ? p : String.format("<div>%s</div>", p);
            }).collect(Collectors.joining("\n"));
            this.html = head.trim().length() > 0 ? String.format("<html><head>\n%s\n</head><body>\n%s\n</body></html>", head, body) : (body.trim().length() > 0 ? String.format("<html><body>\n%s\n</body></html>", body) : "");
        }
        return this.html;
    }

    public Map<String, Object> getBodyProperties() {
        return this.bodyProperties;
    }

    public void setBodyProperties(Map<String, Object> bodyProperties) {
        this.bodyProperties = bodyProperties;
    }

    public EmailMessage property(String key, Object value) {
        this.bodyProperties.put(key, value);
        return this;
    }

    public List<EmailAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<EmailAttachment>();
        }
        return this.attachments;
    }

    public void setAttachments(List<EmailAttachment> attachments) {
        this.attachments = new ArrayList<EmailAttachment>();
        this.attachments.addAll(attachments);
    }

    public EmailMessage attach(File file) throws IOException {
        this.getAttachments().add(new EmailAttachment(file.toPath()));
        return this;
    }

    public EmailMessage attach(Path filePath) throws IOException {
        this.getAttachments().add(new EmailAttachment(filePath));
        return this;
    }

    public EmailMessage attach(String fileName, InputStream fileContent, String mimeType) {
        this.getAttachments().add(new EmailAttachment(fileName, fileContent, mimeType));
        return this;
    }

    public boolean hasAttachments() {
        List<EmailAttachment> attachments = this.getAttachments();
        return attachments != null && !attachments.isEmpty();
    }

    public boolean isRead() {
        return this.isRead != null && this.isRead != false;
    }

    @JsonIgnore
    public boolean isUnread() {
        return this.isRead != null && this.isRead == false;
    }

    public void setRead(boolean read) {
        this.isRead = read;
    }

    public EmailMessage markRead() {
        this.setRead(true);
        return this;
    }

    public EmailMessage markUnread() {
        this.setRead(false);
        return this;
    }

    public EmailMessage getForwardedMessage() {
        return this.forwardedMessage;
    }

    public EmailMessage getReplyOnMessage() {
        return this.replyOnMessage;
    }

    public EmailMessage forwardMessage(boolean withAttachments) {
        EmailMessage msg = new EmailMessage();
        msg.setSubject("Fwd: " + this.getSubject());
        msg.setCharset(this.getCharset());
        msg.forwardedMessage = this;
        if (withAttachments) {
            msg.setAttachments(this.getAttachments());
        }
        return msg;
    }

    public EmailMessage replyMessage(boolean withAttachments) {
        EmailMessage msg = new EmailMessage();
        List<EmailAddress> recipients = this.getReplyTo();
        if (recipients == null || recipients.isEmpty()) {
            recipients = new ArrayList<EmailAddress>();
            recipients.add(this.getFrom() != null ? this.getFrom() : this.getSender());
        }
        msg.setRecipients(recipients);
        msg.setSubject("Re: " + this.getSubject());
        msg.setCharset(this.getCharset());
        msg.replyOnMessage = this;
        if (withAttachments) {
            msg.setAttachments(this.getAttachments());
        }
        return msg;
    }

    public EmailMessage replyAllMessage(boolean withAttachments) {
        EmailMessage msg = this.replyMessage(withAttachments);
        List<EmailAddress> recipients = msg.getRecipients();
        EmailAddress currentSender = msg.getSender();
        recipients.addAll(this.getRecipients().stream().filter(r -> !r.equals(currentSender) && !recipients.contains(r)).collect(Collectors.toList()));
        msg.setCcRecipients(this.getCcRecipients().stream().filter(r -> !r.equals(currentSender) && !recipients.contains(r)).collect(Collectors.toList()));
        return msg;
    }

    public void send() {
        if (this.emailSender != null) {
            this.emailSender.sendMessage(this);
        }
    }

    public void send(EmailSender emailSender) {
        if (emailSender != null) {
            this.emailSender = emailSender;
            this.emailSender.sendMessage(this);
        }
    }

    public String toString() {
        return "EmailMessage{id='" + this.id + '\'' + ", senderName='" + this.senderName + '\'' + ", subject='" + this.subject + '\'' + ", bodyParts=" + this.bodyParts + '}';
    }

    public String toJson(boolean isPrettyPrint) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return isPrettyPrint ? om.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this) : om.writeValueAsString((Object)this);
    }

    public static EmailMessage fromJson(String json) throws JsonProcessingException {
        ObjectMapper om = new ObjectMapper();
        return (EmailMessage)om.readValue(json, EmailMessage.class);
    }

    protected void beforeSend() {
    }

    protected String getConfigParam(String template) {
        if (this.emailSender == null) {
            return null;
        }
        String result = this.emailSender.getConfigParam(String.format(template, this.typeName));
        if (result == null && !DEFAULT_EMAIL_TYPE_NAME.equals(this.typeName)) {
            this.emailSender.getConfigParam(String.format(template, DEFAULT_EMAIL_TYPE_NAME));
        }
        return result;
    }
}

