/*
 * Decompiled with CFR 0.152.
 */
package eu.easyrpa.openframework.email;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.easyrpa.openframework.core.sevices.RPAServicesAccessor;
import eu.easyrpa.openframework.email.EmailMessage;
import eu.easyrpa.openframework.email.service.EmailServiceFactory;
import eu.easyrpa.openframework.email.service.EmailServiceSecret;
import eu.easyrpa.openframework.email.service.InboundEmailProtocol;
import eu.easyrpa.openframework.email.service.InboundEmailService;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.inject.Inject;

public class EmailClient {
    private static final String DEFAULT_INBOX_FOLDER_NAME = "INBOX";
    private static final Duration DEFAULT_CHECK_TIMEOUT = Duration.ofHours(1L);
    private static final Duration DEFAULT_CHECK_INTERVAL = Duration.ofMinutes(1L);
    private static final InboundEmailProtocol DEFAULT_INBOUND_EMAIL_PROTOCOL = InboundEmailProtocol.IMAP;
    private RPAServicesAccessor rpaServices;
    private String server;
    private InboundEmailProtocol protocol;
    private String secret;
    private InboundEmailService service;
    private String defaultFolder;

    public EmailClient() {
    }

    @Inject
    public EmailClient(RPAServicesAccessor rpaServices) {
        this.rpaServices = rpaServices;
    }

    public String getServer() {
        if (this.server == null) {
            this.server = this.getConfigParam("inbound.email.server");
        }
        return this.server;
    }

    public void setServer(String emailServerHostAndPort) {
        this.server = emailServerHostAndPort;
        this.service = null;
    }

    public EmailClient server(String emailServerHostAndPort) {
        this.setServer(emailServerHostAndPort);
        return this;
    }

    public InboundEmailProtocol getProtocol() {
        if (this.protocol == null) {
            String protocolStr = this.getConfigParam("inbound.email.protocol");
            this.protocol = protocolStr != null ? InboundEmailProtocol.valueOf(protocolStr.toUpperCase()) : DEFAULT_INBOUND_EMAIL_PROTOCOL;
        }
        return this.protocol;
    }

    public void setProtocol(InboundEmailProtocol protocol) {
        this.protocol = protocol;
        this.service = null;
    }

    public EmailClient protocol(InboundEmailProtocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public EmailClient protocol(String protocol) {
        this.setProtocol(InboundEmailProtocol.valueOf(protocol.toUpperCase()));
        return this;
    }

    public String getSecret() {
        String secretAlias;
        if (this.secret == null && (secretAlias = this.getConfigParam("inbound.email.secret")) != null) {
            this.secret = (String)this.rpaServices.getSecret(secretAlias, String.class);
        }
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
        this.service = null;
    }

    public EmailClient secret(String secret) {
        this.setSecret(secret);
        return this;
    }

    public EmailClient secret(String userName, String password) {
        try {
            this.setSecret(new ObjectMapper().writeValueAsString((Object)new EmailServiceSecret(userName, password)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String getDefaultFolder() {
        if (this.defaultFolder == null) {
            String folderName = this.getConfigParam("mailbox.default.folder");
            this.defaultFolder = folderName != null ? folderName : DEFAULT_INBOX_FOLDER_NAME;
        }
        return this.defaultFolder;
    }

    public void setDefaultFolder(String defaultFolder) {
        this.defaultFolder = defaultFolder;
    }

    public EmailClient defaultFolder(String defaultFolder) {
        this.setDefaultFolder(defaultFolder);
        return this;
    }

    public int getMessageCount() {
        this.initService();
        return this.getMessageCount(this.getDefaultFolder());
    }

    public int getMessageCount(String folderName) {
        this.initService();
        return this.service.getMessageCount(folderName);
    }

    public EmailMessage fetchMessage(String messageId) {
        this.initService();
        return this.service.fetchMessage(messageId);
    }

    public List<EmailMessage> fetchMessages() {
        this.initService();
        return this.service.fetchMessages(this.getDefaultFolder(), null);
    }

    public List<EmailMessage> fetchMessages(String folderName) {
        this.initService();
        return this.service.fetchMessages(folderName, null);
    }

    public List<EmailMessage> fetchMessages(Predicate<EmailMessage> isSatisfy) {
        this.initService();
        return this.service.fetchMessages(this.getDefaultFolder(), isSatisfy);
    }

    public List<EmailMessage> fetchMessages(String folderName, Predicate<EmailMessage> isSatisfy) {
        this.initService();
        return this.service.fetchMessages(folderName, isSatisfy);
    }

    public List<EmailMessage> fetchAllMessages() {
        this.initService();
        return this.service.fetchAllMessages(null);
    }

    public List<EmailMessage> fetchAllMessages(Predicate<EmailMessage> isSatisfy) {
        this.initService();
        return this.service.fetchAllMessages(isSatisfy);
    }

    public List<EmailMessage> fetchUnreadMessages(boolean markRead) {
        this.initService();
        return this.service.fetchUnreadMessages(this.getDefaultFolder(), markRead);
    }

    public List<EmailMessage> fetchUnreadMessages(String folderName, boolean markRead) {
        this.initService();
        return this.service.fetchUnreadMessages(folderName, markRead);
    }

    public CompletableFuture<List<EmailMessage>> waitMessages(Predicate<EmailMessage> isSatisfy) {
        this.initService();
        return this.service.waitMessages(this.getDefaultFolder(), isSatisfy, DEFAULT_CHECK_TIMEOUT, DEFAULT_CHECK_INTERVAL);
    }

    public CompletableFuture<List<EmailMessage>> waitMessages(Predicate<EmailMessage> isSatisfy, Duration timeout) {
        this.initService();
        return this.service.waitMessages(this.getDefaultFolder(), isSatisfy, timeout, DEFAULT_CHECK_INTERVAL);
    }

    public CompletableFuture<List<EmailMessage>> waitMessages(Predicate<EmailMessage> isSatisfy, Duration timeout, Duration checkInterval) {
        this.initService();
        return this.service.waitMessages(this.getDefaultFolder(), isSatisfy, timeout, checkInterval);
    }

    public CompletableFuture<List<EmailMessage>> waitMessages(String folderName, Predicate<EmailMessage> isSatisfy) {
        this.initService();
        return this.service.waitMessages(folderName, isSatisfy, DEFAULT_CHECK_TIMEOUT, DEFAULT_CHECK_INTERVAL);
    }

    public CompletableFuture<List<EmailMessage>> waitMessages(String folderName, Predicate<EmailMessage> isSatisfy, Duration timeout) {
        this.initService();
        return this.service.waitMessages(folderName, isSatisfy, timeout, DEFAULT_CHECK_INTERVAL);
    }

    public CompletableFuture<List<EmailMessage>> waitMessages(String folderName, Predicate<EmailMessage> isSatisfy, Duration timeout, Duration checkInterval) {
        this.initService();
        return this.service.waitMessages(folderName, isSatisfy, timeout, checkInterval);
    }

    public EmailMessage copyMessage(EmailMessage message, String targetFolder) {
        this.initService();
        return this.service.copyMessage(message, targetFolder);
    }

    public EmailMessage moveMessage(EmailMessage message, String targetFolder) {
        this.initService();
        return this.service.moveMessage(message, targetFolder);
    }

    public void updateMessage(EmailMessage message) {
        this.initService();
        this.service.updateMessage(message);
    }

    public void updateMessages(List<EmailMessage> messages) {
        this.initService();
        this.service.updateMessages(messages);
    }

    public void deleteMessage(EmailMessage message) {
        this.initService();
        this.service.deleteMessage(message);
    }

    public void deleteMessages(List<EmailMessage> messages) {
        this.initService();
        this.service.deleteMessages(messages);
    }

    public List<String> listFolders() {
        this.initService();
        return this.service.listFolders();
    }

    public boolean createFolder(String folderName) {
        this.initService();
        return this.service.createFolder(folderName);
    }

    public boolean renameFolder(String folderName, String newFolderName) {
        this.initService();
        return this.service.renameFolder(folderName, newFolderName);
    }

    public boolean deleteFolder(String folderName) {
        this.initService();
        return this.service.deleteFolder(folderName);
    }

    protected String getConfigParam(String key) {
        String result = null;
        if (this.rpaServices == null) {
            return null;
        }
        try {
            result = this.rpaServices.getConfigParam(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void initService() {
        if (this.service == null) {
            this.service = EmailServiceFactory.getInstance().getInboundService(this.getServer(), this.getProtocol(), this.getSecret());
        }
    }
}

