/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.utils;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import eu.easypush.pushlibrary.R;
import eu.easypush.pushlibrary.preferences.EasypushPreferences;
import eu.easypush.pushlibrary.tasks.AddDeviceDebugTask;
import eu.easypush.pushlibrary.tasks.AddDeviceProjectTask;
import eu.easypush.pushlibrary.tasks.RemoveDeviceDebugTask;
import eu.easypush.pushlibrary.tasks.SetMessageReadTask;
import eu.easypush.pushlibrary.tasks.SetMessageReceivedTask;
import eu.easypush.pushlibrary.utils.PushConstants;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;

@TargetApi(value=11)
public class PushUtils
implements PushConstants {
    public static final String PROPERTY_REG_ID = "registration_id";
    public static final String PROPERTY_APP_VERSION = "appVersion";
    public static final String PROPERTY_GROUPS = "registrationGroups";
    public static final String PROPERTY_MODE = "easypush_mode";
    public static final String PROPERTY_APPLICATION_NAME = "easypushAppName";
    public static final String PROPERTY_PROJECT_TOKEN = "easypushProjectToken";
    public static final String PROPERTY_API_SERVER = "easypushApiServer";

    public static boolean isGlobalPushEnabled(Context context) {
        return true;
    }

    public static boolean isApplicationPushEnabled(Context context) {
        if (context == null) {
            Log.e((String)"EasyPush Library", (String)"Context can not be null");
            return true;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean isPushEnabledInPreference = sp.getBoolean(context.getString(R.string.easypush_alert_preference), false);
        if (!isPushEnabledInPreference) {
            return false;
        }
        HashSet<String> hoursNotificationDisabled = null;
        hoursNotificationDisabled = Build.VERSION.SDK_INT >= 11 ? sp.getStringSet(context.getString(R.string.easypush_hours_preference), new HashSet()) : new HashSet<String>(Arrays.asList(sp.getString(context.getString(R.string.easypush_hours_preference), "").split("\u0001\u0007\u001d\u0007\u0001")));
        Calendar c = Calendar.getInstance();
        String hour = "" + c.get(11);
        return !hoursNotificationDisabled.contains(hour);
    }

    public static void setPushEnabled(Context context, boolean enabled) {
        if (context == null) {
            Log.e((String)"EasyPush Library", (String)"Context can not be null");
            return;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(context.getString(R.string.easypush_alert_preference), enabled);
        editor.commit();
    }

    public static Uri getPushSoundUri(Context context) {
        if (context == null) {
            Log.e((String)"EasyPush Library", (String)"Context can not be null");
            return null;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String defaultSoundUri = sp.getString(context.getString(R.string.easypush_sound_preference), null);
        if (defaultSoundUri == null) {
            return RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)2);
        }
        return Uri.parse((String)defaultSoundUri);
    }

    public static boolean isUserNotificationChoiceDone(Context context) {
        if (context == null) {
            Log.e((String)"EasyPush Library", (String)"Context can not be null");
            return false;
        }
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return preferences.getBoolean(context.getString(R.string.isusernotificationchoicedone_key), false);
    }

    public static String getProjectToken(Context context) {
        if (context == null) {
            Log.e((String)"EasyPush Library", (String)"Context can not be null");
            return "";
        }
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        if (prefs.contains(PROPERTY_PROJECT_TOKEN)) {
            return prefs.getString(PROPERTY_PROJECT_TOKEN, "");
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String easyPushProject = bundle.getString("EASYPUSH_PROJECT");
            if (!TextUtils.isEmpty((CharSequence)easyPushProject)) {
                return easyPushProject;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public static void setEPApplicationName(Context context, String applicationName) {
        if (context == null || applicationName == null) {
            Log.e((String)"EasyPush Library", (String)"Context or application Name can not be null");
            return;
        }
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_APPLICATION_NAME, applicationName);
        editor.commit();
    }

    public static String getApplicationName(Context context) {
        if (context == null) {
            Log.e((String)"EasyPush Library", (String)"Context can not be null");
            return "";
        }
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        if (prefs.contains(PROPERTY_APPLICATION_NAME)) {
            return prefs.getString(PROPERTY_APPLICATION_NAME, "");
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String easyPushApplication = bundle.getString("EASYPUSH_APPLICATION");
            if (!TextUtils.isEmpty((CharSequence)easyPushApplication)) {
                return easyPushApplication;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public static void setEPMode(Context context, boolean isProductionMode) {
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean(PROPERTY_MODE, isProductionMode);
        editor.commit();
    }

    public static void setEPProjectToken(Context context, String projectToken) {
        if (context == null || projectToken == null) {
            Log.e((String)"EasyPush Library", (String)"Context or projectToken can not be null");
            return;
        }
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_PROJECT_TOKEN, projectToken);
        editor.commit();
    }

    public static boolean isProductionMode(Context context) {
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        if (prefs.contains(PROPERTY_MODE)) {
            return prefs.getBoolean(PROPERTY_MODE, true);
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String easypushMode = bundle.getString("EASYPUSH_MODE");
            if (!TextUtils.isEmpty((CharSequence)easypushMode)) {
                return easypushMode == "PRODUCTION";
            }
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return true;
    }

    public static String getDeviceId(Context context) {
        return Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
    }

    public static String getRegistrationId(Context context) {
        int currentVersion;
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        String registrationId = prefs.getString(PROPERTY_REG_ID, "");
        if (TextUtils.isEmpty((CharSequence)registrationId)) {
            Log.i((String)"EasyPush_Library", (String)"Registration not found.");
            return "";
        }
        int registeredVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
        if (registeredVersion != (currentVersion = PushUtils.getAppVersion(context))) {
            Log.i((String)"EasyPush_Library", (String)"App version changed.");
            return "";
        }
        return registrationId;
    }

    public static SharedPreferences getGCMPreferences(Context context) {
        return context.getSharedPreferences(context.getPackageName(), 0);
    }

    public static int getAppVersion(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Could not get package name: " + (Object)((Object)e));
        }
    }

    public static void setGroupsForPush(Context c, String ... groups) {
        if (groups != null) {
            SharedPreferences prefs = PushUtils.getGCMPreferences(c);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString(PROPERTY_GROUPS, TextUtils.join((CharSequence)",", (Object[])groups));
            editor.commit();
        } else {
            Log.w((String)"EasyPush Library", (String)"Warning : groups are null, all groups will be deleted for this user");
            SharedPreferences prefs = PushUtils.getGCMPreferences(c);
            SharedPreferences.Editor editor = prefs.edit();
            editor.remove(PROPERTY_GROUPS);
            editor.commit();
        }
    }

    public static void modifyGroupsForPush(Context c, String ... groups) {
        if (groups != null) {
            PushUtils.setGroupsForPush(c, groups);
            new AddDeviceProjectTask(c).execute(new Void[0]);
        }
    }

    public static String[] getGroupsForPush(Context c) {
        SharedPreferences prefs = PushUtils.getGCMPreferences(c);
        return prefs.getString(PROPERTY_GROUPS, "").split(",");
    }

    public static void setEPServerAdress(Context context, String serverAdress) {
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString(PROPERTY_API_SERVER, serverAdress);
        editor.commit();
    }

    public static String getServerAdress(Context context) {
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        if (prefs.contains(PROPERTY_API_SERVER)) {
            return prefs.getString(PROPERTY_API_SERVER, "api.easypush.eu");
        }
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String apiServer = bundle.getString("EASYPUSH_API_SERVER");
            if (!TextUtils.isEmpty((CharSequence)apiServer)) {
                return apiServer;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "api.easypush.eu";
    }

    public static void launchPreferenceActivity(Context context) {
        context.startActivity(new Intent(context, EasypushPreferences.class));
    }

    public static void addDeviceDebug(Context _context) {
        new AddDeviceDebugTask(_context).execute(new Void[0]);
    }

    public static void removeDeviceDebug(Context _context) {
        new RemoveDeviceDebugTask(_context).execute(new Void[0]);
    }

    public static void setMessageRead(Context _context, String _messageId) {
        new SetMessageReadTask(_context, _messageId).execute(new Void[0]);
    }

    public static void setMessageReceived(Context _context, String _messageId) {
        new SetMessageReceivedTask(_context, _messageId).execute(new Void[0]);
    }

    public static void askUserForPush(final Context c) {
        final SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)c);
        AlertDialog.Builder b = new AlertDialog.Builder(c);
        b.setTitle(R.string.easypush_account_name);
        View dialogLayout = LayoutInflater.from((Context)c).inflate(R.layout.easypush_alert_dialog, null);
        b.setView(dialogLayout);
        try {
            PackageInfo pinfo = c.getPackageManager().getPackageInfo(c.getPackageName(), 0);
            ((TextView)dialogLayout.findViewById(R.id.activatePushQuestionId)).setText((CharSequence)c.getResources().getString(R.string.activatePushQuestion, new Object[]{pinfo.applicationInfo.loadLabel(c.getPackageManager())}));
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)c.getString(R.string.activatePushExplanation))) {
            dialogLayout.findViewById(R.id.explanation_block).setVisibility(8);
        } else {
            dialogLayout.findViewById(R.id.explanation_block).setVisibility(0);
        }
        b.setPositiveButton(17039379, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SharedPreferences.Editor editor = sp.edit();
                editor.putBoolean(c.getString(R.string.easypush_alert_preference), true);
                editor.putBoolean("Easypush_Notification_Preference_set", true);
                editor.commit();
                new AddDeviceProjectTask(c).execute(new Void[0]);
            }
        });
        b.setNegativeButton(17039369, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                SharedPreferences.Editor editor = sp.edit();
                editor.putBoolean(c.getString(R.string.easypush_alert_preference), false);
                editor.putBoolean("Easypush_Notification_Preference_set", true);
                editor.commit();
                new AddDeviceProjectTask(c).execute(new Void[0]);
            }
        });
        b.setCancelable(false);
        b.show();
    }
}

