/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.utils;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import eu.easypush.pushlibrary.events.OnNotificationRegistrationListener;
import eu.easypush.pushlibrary.requests.EasyPushRequest;
import eu.easypush.pushlibrary.utils.PushConstants;
import eu.easypush.pushlibrary.utils.PushUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;

public class PushRegistrar
implements PushConstants {
    public static final String EXTRA_MESSAGE = "message";
    private static final int PLAY_SERVICES_RESOLUTION_REQUEST = 9000;
    private static final int MAX_ATTEMPTS = 5;
    private static final int BACKOFF_MILLI_SECONDS = 2000;
    private static final Random random = new Random();
    private static final ArrayList<OnNotificationRegistrationListener> onNotificationRegistrationListeners = new ArrayList();

    public static void addOnNotificationRegistrationListeners(OnNotificationRegistrationListener listener) {
        if (!onNotificationRegistrationListeners.contains(listener)) {
            onNotificationRegistrationListeners.add(listener);
        }
    }

    public static void removeOnNotificationRegistrationListeners(OnNotificationRegistrationListener listener) {
        onNotificationRegistrationListeners.remove(listener);
    }

    private static void preventAllOnNotificationRegistrationIdReceivedListeners(String registrationId) {
        for (OnNotificationRegistrationListener listener : onNotificationRegistrationListeners) {
            try {
                listener.notificationRegistrationIdReceived(registrationId);
            }
            catch (Throwable throwable) {}
        }
    }

    private static void preventAllOnNotificationRegistrationErrorListeners(String error) {
        for (OnNotificationRegistrationListener listener : onNotificationRegistrationListeners) {
            try {
                listener.notificationRegistrationInError(error);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void checkDevice(Context c) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)c);
        boolean notificationPreferenceSet = sp.getBoolean("Easypush_Notification_Preference_set", false);
        if (!notificationPreferenceSet) {
            PushUtils.askUserForPush(c);
        }
        if (PushRegistrar.checkPlayServices(c)) {
            PushRegistrar.removeAccountIfNeeded(c);
        }
    }

    public static void register(final Context c, final String ... senderIds) {
        String regid = PushUtils.getRegistrationId(c);
        if (TextUtils.isEmpty((CharSequence)regid)) {
            new AsyncTask<Void, String, String>(){

                protected String doInBackground(Void ... params) {
                    String msg = "";
                    try {
                        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)c);
                        String regid = gcm.register(senderIds);
                        msg = "Device registered, registration ID=" + regid;
                        PushRegistrar.sendRegistrationIdToBackend(c, regid);
                        PushRegistrar.storeRegistrationId(c, regid);
                        PushRegistrar.preventAllOnNotificationRegistrationIdReceivedListeners(regid);
                    }
                    catch (IOException ex) {
                        msg = "Error :" + ex.getMessage();
                        PushRegistrar.preventAllOnNotificationRegistrationErrorListeners(ex.getMessage());
                    }
                    return msg;
                }
            }.execute((Object[])new Void[]{null, null, null});
        } else {
            PushRegistrar.preventAllOnNotificationRegistrationIdReceivedListeners(regid);
        }
    }

    public static void checkAndRegister(Context c, String ... senderIds) {
        Log.d((String)"EasyPush_Library", (String)"check And Register start");
        if (senderIds != null) {
            SharedPreferences.Editor editor = PreferenceManager.getDefaultSharedPreferences((Context)c).edit();
            editor.putString("easypush_senderId", TextUtils.join((CharSequence)",", (Object[])senderIds));
            editor.commit();
        }
        Log.d((String)"EasyPush_Library", (String)"Check device");
        PushRegistrar.checkDevice(c);
        Log.d((String)"EasyPush_Library", (String)"Register to easypush server");
        PushRegistrar.register(c, senderIds);
    }

    public static boolean checkPlayServices(Context c) {
        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)c);
        if (resultCode != 0) {
            if (GooglePlayServicesUtil.isUserRecoverableError((int)resultCode)) {
                GooglePlayServicesUtil.getErrorDialog((int)resultCode, (Activity)((Activity)c), (int)9000).show();
            } else {
                Log.i((String)"EasyPush_Library", (String)"This device is not supported.");
            }
            return false;
        }
        return true;
    }

    private static void storeRegistrationId(Context context, String regId) {
        SharedPreferences prefs = PushUtils.getGCMPreferences(context);
        int appVersion = PushUtils.getAppVersion(context);
        Log.i((String)"EasyPush_Library", (String)("Saving regId on app version " + appVersion));
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("registration_id", regId);
        editor.putInt("appVersion", appVersion);
        editor.commit();
    }

    private static void sendRegistrationIdToBackend(Context c, String registrationId) {
        long backoff = 2000 + random.nextInt(1000);
        String deviceId = PushUtils.getDeviceId(c);
        for (int i = 1; i <= 5; ++i) {
            Log.d((String)"EasyPush_Library", (String)("Attempt #" + i + " to register"));
            if (EasyPushRequest.addDeviceProject(c, PushUtils.getProjectToken(c), deviceId, registrationId, PushUtils.getApplicationName(c), PushUtils.isProductionMode(c))) {
                return;
            }
            if (i == 5) break;
            try {
                Log.d((String)"EasyPush_Library", (String)("Sleeping for " + backoff + " ms before retry"));
                Thread.sleep(backoff);
            }
            catch (InterruptedException e1) {
                Log.d((String)"EasyPush_Library", (String)"Thread interrupted: abort remaining retries!");
                Thread.currentThread().interrupt();
            }
            backoff *= 2L;
        }
    }

    private static void removeAccountIfNeeded(Context c) {
        try {
            Account[] accounts;
            AccountManager accMgr = AccountManager.get((Context)c);
            for (Account accountTmp : accounts = accMgr.getAccountsByType("EasyPush.eu")) {
                accMgr.removeAccount(accountTmp, null, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

