/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.utils;

import android.content.Context;
import android.os.Build;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public class NetworkUtils {
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String ENCODING_GZIP = "gzip";

    private static String buildUserAgent(Context context) {
        return "1.0.0;" + System.getProperty("http.agent") + ";" + Build.VERSION.SDK_INT;
    }

    public static HttpResponse getHtml(String url, Context context) {
        try {
            URI uri = new URI(url);
            HttpGet methodGet = new HttpGet(uri);
            methodGet.addHeader("pragma", "no-cache");
            HttpResponse res = NetworkUtils.getHttpClient(context).execute((HttpUriRequest)methodGet);
            return res;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpResponse getHtmlPost(String url, List<NameValuePair> nvps, Context context) {
        try {
            URI uri = new URI(url);
            HttpPost methodPost = new HttpPost(uri);
            methodPost.addHeader("pragma", "no-cache");
            if (nvps != null) {
                methodPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, "UTF-8"));
            }
            HttpResponse res = NetworkUtils.getHttpClient(context).execute((HttpUriRequest)methodPost);
            return res;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static HttpClient getHttpClient(Context context) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)NetworkUtils.buildUserAgent(context));
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)params);
        client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) {
                if (!request.containsHeader(NetworkUtils.HEADER_ACCEPT_ENCODING)) {
                    request.addHeader(NetworkUtils.HEADER_ACCEPT_ENCODING, NetworkUtils.ENCODING_GZIP);
                }
            }
        });
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) {
                HttpEntity entity = response.getEntity();
                Header encoding = entity.getContentEncoding();
                if (encoding != null) {
                    for (HeaderElement element : encoding.getElements()) {
                        if (!element.getName().equalsIgnoreCase(NetworkUtils.ENCODING_GZIP)) continue;
                        response.setEntity((HttpEntity)new InflatingEntity(response.getEntity()));
                        break;
                    }
                }
            }
        });
        return client;
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        public InflatingEntity(HttpEntity wrapped) {
            super(wrapped);
        }

        public InputStream getContent() throws IOException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }
}

