/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.services;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.util.Log;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import eu.easypush.pushlibrary.notifications.EasypushNotification;
import eu.easypush.pushlibrary.notifications.NotificationFactory;
import eu.easypush.pushlibrary.notifications.SimpleNotification;
import eu.easypush.pushlibrary.utils.NotificationUtils;
import eu.easypush.pushlibrary.utils.PushConstants;
import eu.easypush.pushlibrary.utils.PushUtils;
import org.json.JSONObject;

public class GCMIntentService
extends IntentService
implements PushConstants {
    public static final int NOTIFICATION_ID = 1;
    private NotificationManager mNotificationManager;
    NotificationCompat.Builder builder;

    public GCMIntentService() {
        super("GcmIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        Bundle extras = intent.getExtras();
        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)this);
        String messageType = gcm.getMessageType(intent);
        if (!extras.isEmpty() && !"send_error".equals(messageType) && !"deleted_messages".equals(messageType) && "gcm".equals(messageType) && PushUtils.isGlobalPushEnabled((Context)this) && PushUtils.isApplicationPushEnabled((Context)this)) {
            try {
                EasypushNotification easypushNotification;
                JSONObject object = new JSONObject(extras.getString("message"));
                NotificationUtils.preventAllOnNotificationRegistrationIdReceivedListeners(object);
                if (object.optString("EZRecId", null) != null) {
                    PushUtils.setMessageReceived((Context)this, object.getString("EZRecId"));
                }
                if ((easypushNotification = NotificationUtils.getDefaultNotification((Context)this, object)) == null) {
                    easypushNotification = object.optString("EZType", null) != null ? NotificationFactory.getNotification(object.getString("EZType"), object) : new SimpleNotification(object);
                }
                final EasypushNotification notificationToLaunch = easypushNotification;
                AsyncTask<Void, Void, Void> execute = new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... voids) {
                        String applicationName = GCMIntentService.this.getApplicationName((Context)GCMIntentService.this);
                        NotificationCompat.Builder builder = notificationToLaunch.createNotification((Context)GCMIntentService.this, applicationName);
                        notificationToLaunch.launchNotification((Context)GCMIntentService.this, applicationName.hashCode(), builder);
                        return null;
                    }
                };
                execute.execute((Object[])new Void[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            Log.i((String)"EasyPush_Library", (String)("Received: " + extras.toString()));
        }
    }

    private String getApplicationName(Context context) {
        ApplicationInfo ai;
        PackageManager pm = context.getPackageManager();
        try {
            ai = pm.getApplicationInfo(this.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        return ai != null ? pm.getApplicationLabel(ai) : "(unknown)";
    }
}

