/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.requests;

import android.content.Context;
import android.os.Build;
import eu.easypush.pushlibrary.utils.NetworkUtils;
import eu.easypush.pushlibrary.utils.PushUtils;
import java.util.ArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class EasyPushRequest {
    public static boolean addDeviceProject(Context context, String projectToken, String deviceId, String registrationId, String applicationName, boolean productionMode) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair("projectToken", projectToken));
        list.add((NameValuePair)new BasicNameValuePair("applicationType", "androidgcm"));
        list.add((NameValuePair)new BasicNameValuePair("applicationName", applicationName));
        list.add((NameValuePair)new BasicNameValuePair("deviceId", deviceId));
        list.add((NameValuePair)new BasicNameValuePair("active", PushUtils.isGlobalPushEnabled(context) && PushUtils.isApplicationPushEnabled(context) ? "true" : "false"));
        list.add((NameValuePair)new BasicNameValuePair("registrationId", registrationId));
        list.add((NameValuePair)new BasicNameValuePair("osName", "ANDROID"));
        list.add((NameValuePair)new BasicNameValuePair("brandName", Build.MANUFACTURER));
        list.add((NameValuePair)new BasicNameValuePair("mode", productionMode ? "prod" : "dev"));
        list.add((NameValuePair)new BasicNameValuePair("deviceModel", Build.DEVICE));
        list.add((NameValuePair)new BasicNameValuePair("deviceVersion", Build.VERSION.CODENAME));
        String[] groups = PushUtils.getGroupsForPush(context);
        if (groups != null) {
            for (String group : groups) {
                list.add((NameValuePair)new BasicNameValuePair("group", group));
            }
        }
        String url = "http://" + PushUtils.getServerAdress(context) + "/" + "addDeviceProject";
        try {
            HttpResponse response = NetworkUtils.getHtmlPost(url, list, context);
            if (response.getEntity() != null) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public static boolean removeDeviceProject(Context context, String projectToken, String deviceId, String registrationId, String applicationName) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair("projectToken", projectToken));
        list.add((NameValuePair)new BasicNameValuePair("applicationType", "androidgcm"));
        list.add((NameValuePair)new BasicNameValuePair("applicationName", applicationName));
        list.add((NameValuePair)new BasicNameValuePair("deviceId", deviceId));
        list.add((NameValuePair)new BasicNameValuePair("registrationId", registrationId));
        list.add((NameValuePair)new BasicNameValuePair("osName", "ANDROID"));
        list.add((NameValuePair)new BasicNameValuePair("brandName", Build.MANUFACTURER));
        list.add((NameValuePair)new BasicNameValuePair("deviceModel", Build.DEVICE));
        list.add((NameValuePair)new BasicNameValuePair("deviceVersion", Build.VERSION.CODENAME));
        String url = "http://" + PushUtils.getServerAdress(context) + "/" + "removeDeviceProject";
        try {
            HttpResponse response = NetworkUtils.getHtmlPost(url, list, context);
            if (response.getEntity() != null) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public static boolean setMessageRead(Context context, String projectToken, String deviceId, String applicationName, String messageId) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair("projectToken", projectToken));
        list.add((NameValuePair)new BasicNameValuePair("applicationType", "androidgcm"));
        list.add((NameValuePair)new BasicNameValuePair("applicationName", applicationName));
        list.add((NameValuePair)new BasicNameValuePair("deviceId", deviceId));
        list.add((NameValuePair)new BasicNameValuePair("messageId", messageId));
        String url = "http://" + PushUtils.getServerAdress(context) + "/" + "setMessageRead";
        try {
            HttpResponse response = NetworkUtils.getHtmlPost(url, list, context);
            if (response.getEntity() != null) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public static boolean setMessageReceived(Context context, String projectToken, String deviceId, String applicationName, String messageId) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair("projectToken", projectToken));
        list.add((NameValuePair)new BasicNameValuePair("applicationType", "androidgcm"));
        list.add((NameValuePair)new BasicNameValuePair("applicationName", applicationName));
        list.add((NameValuePair)new BasicNameValuePair("deviceId", deviceId));
        list.add((NameValuePair)new BasicNameValuePair("messageId", messageId));
        String url = "http://" + PushUtils.getServerAdress(context) + "/" + "setMessageReceived";
        try {
            HttpResponse response = NetworkUtils.getHtmlPost(url, list, context);
            if (response.getEntity() != null) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public static boolean addDeviceDebug(Context context, String projectToken, String deviceId, String applicationName) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair("projectToken", projectToken));
        list.add((NameValuePair)new BasicNameValuePair("applicationType", "androidgcm"));
        list.add((NameValuePair)new BasicNameValuePair("applicationName", applicationName));
        list.add((NameValuePair)new BasicNameValuePair("deviceId", deviceId));
        String url = "http://" + PushUtils.getServerAdress(context) + "/" + "addDeviceDebug";
        try {
            HttpResponse response = NetworkUtils.getHtmlPost(url, list, context);
            if (response.getEntity() != null) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }

    public static boolean removeDeviceDebug(Context context, String projectToken, String deviceId, String applicationName) {
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        list.add((NameValuePair)new BasicNameValuePair("projectToken", projectToken));
        list.add((NameValuePair)new BasicNameValuePair("applicationType", "androidgcm"));
        list.add((NameValuePair)new BasicNameValuePair("applicationName", applicationName));
        list.add((NameValuePair)new BasicNameValuePair("deviceId", deviceId));
        String url = "http://" + PushUtils.getServerAdress(context) + "/" + "removeDeviceDebug";
        try {
            HttpResponse response = NetworkUtils.getHtmlPost(url, list, context);
            if (response.getEntity() != null) {
                return true;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return false;
    }
}

