/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.preferences;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.preference.ListPreference;
import android.util.AttributeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class EasyPushMultiSelectListPreference
extends ListPreference {
    private String separator = "\u0001\u0007\u001d\u0007\u0001";
    public static final String DEFAULT_SEPARATOR = "\u0001\u0007\u001d\u0007\u0001";
    private boolean[] entryChecked = new boolean[this.getEntries().length];

    public EasyPushMultiSelectListPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public EasyPushMultiSelectListPreference(Context context) {
        this(context, null);
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        CharSequence[] entries = this.getEntries();
        CharSequence[] entryValues = this.getEntryValues();
        if (entries == null || entryValues == null || entries.length != entryValues.length) {
            throw new IllegalStateException("MultiSelectListPreference requires an entries array and an entryValues array which are both the same length");
        }
        this.restoreCheckedEntries();
        DialogInterface.OnMultiChoiceClickListener listener = new DialogInterface.OnMultiChoiceClickListener(){

            public void onClick(DialogInterface dialog, int which, boolean val) {
                ((EasyPushMultiSelectListPreference)EasyPushMultiSelectListPreference.this).entryChecked[which] = val;
            }
        };
        builder.setMultiChoiceItems(entries, this.entryChecked, listener);
    }

    private CharSequence[] unpack(CharSequence val) {
        if (val == null || "".equals(val)) {
            return new CharSequence[0];
        }
        return ((String)val).split(this.separator);
    }

    public CharSequence[] getCheckedValues() {
        return this.unpack(this.getValue());
    }

    private void restoreCheckedEntries() {
        CharSequence[] entryValues = this.getEntryValues();
        CharSequence[] vals = this.unpack(this.getValue());
        if (vals != null) {
            List<CharSequence> valuesList = Arrays.asList(vals);
            for (int i = 0; i < entryValues.length; ++i) {
                CharSequence entry = entryValues[i];
                this.entryChecked[i] = valuesList.contains(entry);
            }
        }
    }

    protected void onDialogClosed(boolean positiveResult) {
        ArrayList<CharSequence> values = new ArrayList<CharSequence>();
        CharSequence[] entryValues = this.getEntryValues();
        if (positiveResult && entryValues != null) {
            for (int i = 0; i < entryValues.length; ++i) {
                if (!this.entryChecked[i]) continue;
                String val = (String)entryValues[i];
                values.add(val);
            }
            String value = EasyPushMultiSelectListPreference.join(values, this.separator);
            this.setSummary(this.prepareSummary(values));
            this.setValueAndEvent(value);
        }
    }

    private void setValueAndEvent(String value) {
        if (this.callChangeListener(this.unpack(value))) {
            this.setValue(value);
        }
    }

    private CharSequence prepareSummary(List<CharSequence> joined) {
        ArrayList<String> titles = new ArrayList<String>();
        CharSequence[] entryTitle = this.getEntries();
        CharSequence[] entryValues = this.getEntryValues();
        int ix = 0;
        for (CharSequence value : entryValues) {
            if (joined.contains(value)) {
                titles.add((String)entryTitle[ix]);
            }
            ++ix;
        }
        return EasyPushMultiSelectListPreference.join(titles, ", ");
    }

    protected Object onGetDefaultValue(TypedArray typedArray, int index) {
        return typedArray.getTextArray(index);
    }

    protected void onSetInitialValue(boolean restoreValue, Object rawDefaultValue) {
        String value = null;
        CharSequence[] defaultValue = rawDefaultValue == null ? new CharSequence[]{} : (CharSequence[])rawDefaultValue;
        List<CharSequence> joined = Arrays.asList(defaultValue);
        String joinedDefaultValue = EasyPushMultiSelectListPreference.join(joined, this.separator);
        value = restoreValue ? this.getPersistedString(joinedDefaultValue) : joinedDefaultValue;
        this.setSummary(this.prepareSummary(Arrays.asList(this.unpack(value))));
        this.setValueAndEvent(value);
    }

    protected static String join(Iterable<?> iterable, String separator) {
        Iterator<?> oIter;
        if (iterable == null || !(oIter = iterable.iterator()).hasNext()) {
            return "";
        }
        StringBuilder oBuilder = new StringBuilder(String.valueOf(oIter.next()));
        while (oIter.hasNext()) {
            oBuilder.append(separator).append(oIter.next());
        }
        return oBuilder.toString();
    }
}

