/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.notifications;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import eu.easypush.pushlibrary.notifications.EasypushNotification;
import eu.easypush.pushlibrary.utils.PushUtils;
import java.util.Random;
import org.json.JSONObject;

public class SimpleNotification
extends EasypushNotification {
    public SimpleNotification(JSONObject _jsonMessage) {
        super(_jsonMessage);
    }

    @Override
    public NotificationCompat.Builder createNotification(Context context, String titleOfApplication) {
        int icon = context.getApplicationInfo().icon;
        long when = System.currentTimeMillis();
        String alert = this.jsonMessage.optString("alert", null);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setTicker((CharSequence)alert);
        builder.setAutoCancel(true);
        builder.setSmallIcon(icon);
        builder.setContentTitle((CharSequence)titleOfApplication);
        builder.setContentText((CharSequence)alert);
        builder.setWhen(when + 2000L);
        builder.setSound(PushUtils.getPushSoundUri(context));
        builder.setDefaults(6);
        NotificationCompat.BigTextStyle bts = new NotificationCompat.BigTextStyle();
        bts.bigText((CharSequence)alert);
        builder.setStyle((NotificationCompat.Style)bts);
        Intent i = this.getIntentToLaunch(context, this.jsonMessage);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)i, (int)0);
        builder.setContentIntent(contentIntent);
        return builder;
    }
}

