/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.notifications;

import eu.easypush.pushlibrary.notifications.EasypushNotification;
import eu.easypush.pushlibrary.notifications.ExpandablePictureNotification;
import eu.easypush.pushlibrary.notifications.SimpleNotification;
import java.util.HashMap;
import org.json.JSONObject;

public class NotificationFactory {
    public static final HashMap<String, String> notificationsByType = new HashMap<String, String>(){
        {
            this.put("simple", SimpleNotification.class.getName());
            this.put("expandablepicture", ExpandablePictureNotification.class.getName());
        }
    };

    public static EasypushNotification getNotification(String type, JSONObject message) {
        String className = notificationsByType.get(type);
        if (className == null) {
            return new SimpleNotification(message);
        }
        try {
            Object myClass = Class.forName(className).getDeclaredConstructor(JSONObject.class).newInstance(message);
            if (myClass instanceof EasypushNotification) {
                return (EasypushNotification)myClass;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SimpleNotification(message);
    }
}

