/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.notifications;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import eu.easypush.pushlibrary.notifications.EasypushNotification;
import eu.easypush.pushlibrary.utils.PushUtils;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;
import org.json.JSONObject;

public class ExpandablePictureNotification
extends EasypushNotification {
    public ExpandablePictureNotification(JSONObject _jsonMessage) {
        super(_jsonMessage);
    }

    @Override
    public NotificationCompat.Builder createNotification(Context context, String titleOfApplication) {
        int icon = context.getApplicationInfo().icon;
        long when = System.currentTimeMillis();
        String alert = this.jsonMessage.optString("alert", null);
        String url = this.jsonMessage.optString("url", null);
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context);
        builder.setTicker((CharSequence)alert);
        builder.setAutoCancel(true);
        builder.setSmallIcon(icon);
        builder.setContentTitle((CharSequence)titleOfApplication);
        builder.setContentText((CharSequence)alert);
        builder.setWhen(when + 2000L);
        builder.setSound(PushUtils.getPushSoundUri(context));
        builder.setDefaults(6);
        if (!TextUtils.isEmpty((CharSequence)url)) {
            try {
                NotificationCompat.BigPictureStyle bps = new NotificationCompat.BigPictureStyle();
                builder.setStyle((NotificationCompat.Style)bps);
                Bitmap bmp = BitmapFactory.decodeStream((InputStream)new URL(url).openConnection().getInputStream());
                bps.bigPicture(bmp);
                bps.setBigContentTitle((CharSequence)titleOfApplication);
                bps.setSummaryText((CharSequence)alert);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        Intent i = this.getIntentToLaunch(context, this.jsonMessage);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)new Random().nextInt(), (Intent)i, (int)0);
        builder.setContentIntent(contentIntent);
        return builder;
    }
}

