/*
 * Decompiled with CFR 0.152.
 */
package eu.easypush.pushlibrary.notifications;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;
import eu.easypush.pushlibrary.utils.NotificationUtils;
import org.json.JSONObject;

public abstract class EasypushNotification {
    protected JSONObject jsonMessage;

    public EasypushNotification(JSONObject _jsonMessage) {
        this.jsonMessage = _jsonMessage;
    }

    public JSONObject getJsonMessage() {
        return this.jsonMessage;
    }

    public void launchNotification(Context context, int id2, NotificationCompat.Builder notificationBuilder) {
        this.beforeLaunchNotification(context, notificationBuilder);
        NotificationUtils.preventAllOnBeforeLaunchNotification(context, notificationBuilder, this.jsonMessage);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Notification notification = notificationBuilder.build();
        notificationManager.notify(id2, notification);
        NotificationUtils.preventAllOnAfterLaunchNotification(context, notification, this.jsonMessage);
        this.afterLaunchNotification(context, notification);
    }

    public void beforeLaunchNotification(Context context, NotificationCompat.Builder notificationBuilder) {
    }

    public void afterLaunchNotification(Context context, Notification notification) {
    }

    public Intent getIntentToLaunch(Context context, JSONObject object) {
        Intent i = NotificationUtils.getLaunchIntentOnNotification(context);
        if (i == null) {
            i = context.getApplicationContext().getPackageManager().getLaunchIntentForPackage(context.getApplicationInfo().packageName);
        }
        if (i != null && Build.VERSION.SDK_INT >= 11) {
            i.setFlags(32768);
        }
        i.putExtra("EasyPushMessage", object.toString());
        return i;
    }

    public abstract NotificationCompat.Builder createNotification(Context var1, String var2);
}

