package eu.easypush.pushlibrary.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.zip.GZIPInputStream;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;

import android.content.Context;
import android.os.Build;

public class NetworkUtils {

	/**
	 * Build and return a user-agent string that can identify this application
	 * to remote servers. Contains the package name and version code.
	 */
	private static String buildUserAgent(final Context context) {
		return "1.0.0;" + System.getProperty("http.agent") + ";"
				+ Build.VERSION.SDK_INT;
	}

	public static HttpResponse getHtml(final String url, final Context context) {
		try {
			HttpResponse res;

			final URI uri = new URI(url);
			final HttpGet methodGet = new HttpGet(uri);

			methodGet.addHeader("pragma", "no-cache");
			res = NetworkUtils.getHttpClient(context).execute(methodGet);
			return res;
		} catch (final URISyntaxException e) {
			e.printStackTrace();
		} catch (final UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (final ClientProtocolException e) {
			e.printStackTrace();
		} catch (final IOException e) {
			e.printStackTrace();

		}
		return null;
	}

	public static HttpResponse getHtmlPost(final String url,
			final List<NameValuePair> nvps, final Context context) {
		try {
			HttpResponse res;

			final URI uri = new URI(url);
			final HttpPost methodPost = new HttpPost(uri);

			methodPost.addHeader("pragma", "no-cache");
			if (nvps != null) {
				methodPost
						.setEntity(new UrlEncodedFormEntity(nvps, HTTP.UTF_8));
			}
			res = NetworkUtils.getHttpClient(context).execute(methodPost);
			return res;
		} catch (final URISyntaxException e) {
			e.printStackTrace();
		} catch (final UnsupportedEncodingException e) {
			e.printStackTrace();
		} catch (final ClientProtocolException e) {
			e.printStackTrace();
		} catch (final IOException e) {
			e.printStackTrace();

		}
		return null;
	}

	private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
	private static final String ENCODING_GZIP = "gzip";

	/**
	 * Generate and return a {@link org.apache.http.client.HttpClient} configured for g use, including
	 * setting an application-specific user-agent string.
	 */
	public static HttpClient getHttpClient(final Context context) {
		final HttpParams params = new BasicHttpParams();

		HttpConnectionParams.setSocketBufferSize(params, 8192);
		HttpProtocolParams.setUserAgent(params,
				NetworkUtils.buildUserAgent(context));

		final DefaultHttpClient client = new DefaultHttpClient(params);

		client.addRequestInterceptor(new HttpRequestInterceptor() {
			@Override
			public void process(HttpRequest request, HttpContext context) {
				// Add header to accept gzip content
				if (!request
						.containsHeader(NetworkUtils.HEADER_ACCEPT_ENCODING)) {
					request.addHeader(NetworkUtils.HEADER_ACCEPT_ENCODING,
							NetworkUtils.ENCODING_GZIP);
				}
			}
		});

		client.addResponseInterceptor(new HttpResponseInterceptor() {
			@Override
			public void process(HttpResponse response, HttpContext context) {
				// Inflate any responses compressed with gzip
				final HttpEntity entity = response.getEntity();
				final Header encoding = entity.getContentEncoding();
				if (encoding != null) {
					for (HeaderElement element : encoding.getElements()) {
						if (element.getName().equalsIgnoreCase(
								NetworkUtils.ENCODING_GZIP)) {
							response.setEntity(new InflatingEntity(response
									.getEntity()));
							break;
						}
					}
				}
			}
		});

		return client;
	}

	private static class InflatingEntity extends HttpEntityWrapper {
		public InflatingEntity(HttpEntity wrapped) {
			super(wrapped);
		}

		@Override
		public InputStream getContent() throws IOException {
			return new GZIPInputStream(this.wrappedEntity.getContent());
		}

		@Override
		public long getContentLength() {
			return -1;
		}
	}

}
