package eu.easypush.pushlibrary.notifications;

import java.net.URL;
import java.util.Random;

import org.json.JSONObject;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.AsyncTask;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import eu.easypush.pushlibrary.utils.PushUtils;

public class ExpandablePictureNotification extends EasypushNotification {

    public ExpandablePictureNotification(JSONObject _jsonMessage){
        super(_jsonMessage);
    }


	@Override
	public NotificationCompat.Builder createNotification(final Context context,
                                   final String titleOfApplication) {


		int icon = context.getApplicationInfo().icon;
		long when = System.currentTimeMillis();

		String alert = jsonMessage.optString("alert", null);
		String url = jsonMessage.optString("url", null);

		NotificationCompat.Builder builder = new NotificationCompat.Builder(
				context);
		builder.setTicker(alert);
		builder.setAutoCancel(true);
		builder.setSmallIcon(icon);
		builder.setContentTitle(titleOfApplication);
		builder.setContentText(alert);
		builder.setWhen(when + 2000);
		builder.setSound(PushUtils.getPushSoundUri(context));
		builder.setDefaults(Notification.DEFAULT_LIGHTS
				| Notification.DEFAULT_VIBRATE);
		if (!TextUtils.isEmpty(url)) {
			try {
				NotificationCompat.BigPictureStyle bps = new NotificationCompat.BigPictureStyle();
				builder.setStyle(bps);
				Bitmap bmp = BitmapFactory.decodeStream(new URL(url)
						.openConnection().getInputStream());
				bps.bigPicture(bmp);
				bps.setBigContentTitle(titleOfApplication);
				bps.setSummaryText(alert);
			} catch (Throwable t) {
			}
		}
		Intent i = getIntentToLaunch(context, jsonMessage);

		PendingIntent contentIntent = PendingIntent.getActivity(context,
				new Random().nextInt(), i, 0);
		builder.setContentIntent(contentIntent);

        return builder;
	}
}
