package eu.easypush.pushlibrary.notifications;

import org.json.JSONObject;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.NotificationCompat;

import eu.easypush.pushlibrary.utils.NotificationUtils;

public abstract class EasypushNotification {

    protected JSONObject jsonMessage;

    public EasypushNotification(JSONObject _jsonMessage){
        this.jsonMessage = _jsonMessage;
    }


    public JSONObject getJsonMessage() {
        return jsonMessage;
    }

    public void launchNotification(Context context, int id,
                                   NotificationCompat.Builder notificationBuilder) {
		beforeLaunchNotification(context, notificationBuilder);
        NotificationUtils.preventAllOnBeforeLaunchNotification(context,
                notificationBuilder, jsonMessage);

		NotificationManager notificationManager = (NotificationManager) context
				.getSystemService(Context.NOTIFICATION_SERVICE);
        Notification notification = notificationBuilder.build();
		notificationManager.notify(id, notification);
        NotificationUtils.preventAllOnAfterLaunchNotification(context,
                notification, jsonMessage);

		afterLaunchNotification(context, notification);

	}

	public void beforeLaunchNotification(Context context,NotificationCompat.Builder notificationBuilder) {
	}

	public void afterLaunchNotification(Context context,
			Notification notification) {
	}

	public Intent getIntentToLaunch(Context context, JSONObject object) {
		Intent i = NotificationUtils.getLaunchIntentOnNotification(context);
		if (i == null) {

			i = context
					.getApplicationContext()
					.getPackageManager()
					.getLaunchIntentForPackage(
							context.getApplicationInfo().packageName);
		}

		if (i != null) {
			if (Build.VERSION.SDK_INT >= 11) {
				i.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
			}

		}
		i.putExtra("EasyPushMessage", object.toString());
		return i;
	}

	public abstract  NotificationCompat.Builder createNotification(Context context,
			String titleOfApplication);
}
