package pushlibrary.requests;

import android.content.Context;
import android.os.Build;

import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

import java.util.ArrayList;

import pushlibrary.utils.NetworkUtils;
import pushlibrary.utils.PushUtils;

public class EasyPushRequest {

	public static boolean addDeviceProject(Context context,
			String projectToken, String deviceId, String registrationId,
			String applicationName, boolean productionMode) {
		ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("projectToken", projectToken));
		list.add(new BasicNameValuePair("applicationType", "androidgcm"));
		list.add(new BasicNameValuePair("applicationName", applicationName));
		list.add(new BasicNameValuePair("deviceId", deviceId));
		list.add(new BasicNameValuePair("active", (PushUtils
				.isGlobalPushEnabled(context) && PushUtils
				.isApplicationPushEnabled(context)) ? "true" : "false"));
		list.add(new BasicNameValuePair("registrationId", registrationId));
		list.add(new BasicNameValuePair("osName", "ANDROID"));
		list.add(new BasicNameValuePair("brandName", Build.MANUFACTURER));
		list.add(new BasicNameValuePair("mode", productionMode ? "prod" : "dev"));
		list.add(new BasicNameValuePair("deviceModel", Build.DEVICE));
		list.add(new BasicNameValuePair("deviceVersion", Build.VERSION.CODENAME));

		String[] groups = PushUtils.getGroupsForPush(context);
		if (groups != null) {
			for (String group : groups) {
				list.add(new BasicNameValuePair("group", group));
			}
		}

		String url = "http://" + PushUtils.getServerAdress(context) + "/"
				+ "addDeviceProject";
		try {
			HttpResponse response = NetworkUtils
					.getHtmlPost(url, list, context);
			if (response.getEntity() != null) {
				return true;
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return false;
	}

	public static boolean removeDeviceProject(Context context,
			String projectToken, String deviceId, String registrationId,
			String applicationName) {
		ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("projectToken", projectToken));
		list.add(new BasicNameValuePair("applicationType", "androidgcm"));
		list.add(new BasicNameValuePair("applicationName", applicationName));
		list.add(new BasicNameValuePair("deviceId", deviceId));
		list.add(new BasicNameValuePair("registrationId", registrationId));
		list.add(new BasicNameValuePair("osName", "ANDROID"));
		list.add(new BasicNameValuePair("brandName", Build.MANUFACTURER));
		list.add(new BasicNameValuePair("deviceModel", Build.DEVICE));
		list.add(new BasicNameValuePair("deviceVersion", Build.VERSION.CODENAME));

		String url = "http://" + PushUtils.getServerAdress(context) + "/"
				+ "removeDeviceProject";
		try {
			HttpResponse response = NetworkUtils
					.getHtmlPost(url, list, context);
			if (response.getEntity() != null) {
				return true;
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return false;
	}

	public static boolean setMessageRead(Context context, String projectToken,
			String deviceId, String applicationName, String messageId) {
		ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("projectToken", projectToken));
		list.add(new BasicNameValuePair("applicationType", "androidgcm"));
		list.add(new BasicNameValuePair("applicationName", applicationName));
		list.add(new BasicNameValuePair("deviceId", deviceId));
		list.add(new BasicNameValuePair("messageId", messageId));

		String url = "http://" + PushUtils.getServerAdress(context) + "/"
				+ "setMessageRead";
		try {
			HttpResponse response = NetworkUtils
					.getHtmlPost(url, list, context);
			if (response.getEntity() != null) {
				return true;
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return false;
	}

	public static boolean setMessageReceived(Context context,
			String projectToken, String deviceId, String applicationName,
			String messageId) {
		ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("projectToken", projectToken));
		list.add(new BasicNameValuePair("applicationType", "androidgcm"));
		list.add(new BasicNameValuePair("applicationName", applicationName));
		list.add(new BasicNameValuePair("deviceId", deviceId));
		list.add(new BasicNameValuePair("messageId", messageId));

		String url = "http://" + PushUtils.getServerAdress(context) + "/"
				+ "setMessageReceived";
		try {
			HttpResponse response = NetworkUtils
					.getHtmlPost(url, list, context);
			if (response.getEntity() != null) {
				return true;
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return false;
	}

	public static boolean addDeviceDebug(Context context, String projectToken,
			String deviceId, String applicationName) {
		ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("projectToken", projectToken));
		list.add(new BasicNameValuePair("applicationType", "androidgcm"));
		list.add(new BasicNameValuePair("applicationName", applicationName));
		list.add(new BasicNameValuePair("deviceId", deviceId));

		String url = "http://" + PushUtils.getServerAdress(context) + "/"
				+ "addDeviceDebug";
		try {
			HttpResponse response = NetworkUtils
					.getHtmlPost(url, list, context);
			if (response.getEntity() != null) {
				return true;
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return false;
	}

	public static boolean removeDeviceDebug(Context context,
			String projectToken, String deviceId, String applicationName) {
		ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
		list.add(new BasicNameValuePair("projectToken", projectToken));
		list.add(new BasicNameValuePair("applicationType", "androidgcm"));
		list.add(new BasicNameValuePair("applicationName", applicationName));
		list.add(new BasicNameValuePair("deviceId", deviceId));

		String url = "http://" + PushUtils.getServerAdress(context) + "/"
				+ "removeDeviceDebug";
		try {
			HttpResponse response = NetworkUtils
					.getHtmlPost(url, list, context);
			if (response.getEntity() != null) {
				return true;
			}
		} catch (Throwable t) {
			t.printStackTrace();
		}
		return false;
	}

}
