package pushlibrary.notifications;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;

import org.json.JSONObject;

import java.util.Random;

import pushlibrary.utils.PushUtils;

public class SimpleNotification extends
        EasypushNotification {

	@Override
	public void createNotification(Context context, JSONObject message,
			String titleOfApplication) {
		int icon = context.getApplicationInfo().icon;
		long when = System.currentTimeMillis();

		String alert = message.optString("alert", null);

		NotificationCompat.Builder builder = new NotificationCompat.Builder(
				context);
		builder.setTicker(alert);
		builder.setAutoCancel(true);
		builder.setSmallIcon(icon);
		builder.setContentTitle(titleOfApplication);
		builder.setContentText(alert);
		builder.setWhen(when + 2000);
		builder.setSound(PushUtils.getPushSoundUri(context));
		builder.setDefaults(Notification.DEFAULT_LIGHTS
				| Notification.DEFAULT_VIBRATE);
		NotificationCompat.BigTextStyle bts = new NotificationCompat.BigTextStyle();
		bts.bigText(alert);
		builder.setStyle(bts);

		Intent i = getIntentToLaunch(context, message);

		PendingIntent contentIntent = PendingIntent.getActivity(context,
				new Random().nextInt(), i, 0);
		builder.setContentIntent(contentIntent);

		launchNotification(context, titleOfApplication.hashCode(),
				builder.build());

	}
}
