package pushlibrary.notifications;

import java.util.HashMap;

public class NotificationFactory {
	public static final HashMap<String, EasypushNotification> notificationsByType = new HashMap<String, EasypushNotification>() {
		{
			put("simple", new SimpleNotification());
			put("expandablepicture", new ExpandablePictureNotification());
		}
	};

	public static EasypushNotification getNotification(String type) {
		return notificationsByType.get(type);
	}
}
