package pushlibrary.notifications;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import org.json.JSONObject;

import pushlibrary.utils.NotificationUtils;

public abstract class EasypushNotification {
	public void launchNotification(Context context, int id,
			Notification notification) {
		beforeLaunchNotification(context, notification);
		NotificationManager notificationManager = (NotificationManager) context
				.getSystemService(Context.NOTIFICATION_SERVICE);
		notificationManager.notify(id, notification);
		afterLaunchNotification(context, notification);

	}

	public void beforeLaunchNotification(Context context,
			Notification notification) {
		NotificationUtils.preventAllOnBeforeLaunchNotification(context,
                notification);
	}

	public void afterLaunchNotification(Context context,
			Notification notification) {
		NotificationUtils.preventAllOnAfterLaunchNotification(context,
                notification);
	}

	public Intent getIntentToLaunch(Context context, JSONObject object) {
		Intent i = NotificationUtils.getLaunchIntentOnNotification(context);
		if (i == null) {

			i = context
					.getApplicationContext()
					.getPackageManager()
					.getLaunchIntentForPackage(
							context.getApplicationInfo().packageName);
		}

		if (i != null) {
			if (Build.VERSION.SDK_INT >= 11) {
				i.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK);
			}

		}
		i.putExtra("EasyPushMessage", object.toString());
		return i;
	}

	public abstract void createNotification(Context context,
			JSONObject message, String titleOfApplication);
}
