package eu.easypush.pushlibrary.utils;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashSet;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;

import org.json.JSONObject;

import eu.easypush.pushlibrary.events.OnAfterLaunchNotification;
import eu.easypush.pushlibrary.events.OnBeforeLaunchNotification;
import eu.easypush.pushlibrary.notifications.EasypushNotification;
import eu.easypush.pushlibrary.notifications.EasypushNotification;

public class NotificationUtils {
	private static String DEFAULT_NOTIFICATION = "EP_default_notification";
	private static String LAUNCH_INTENT = "EP_launch_intent";
	private static String BEFORE_SEND = "EP_before_send";
	private static String AFTER_SEND = "EP_after_send";

	public static void registerDefaultNotification(Context c,
			Class<? extends EasypushNotification> notificationClass) {
        try{
            Constructor<? extends EasypushNotification> constructor = notificationClass.getDeclaredConstructor(JSONObject.class);
            if (constructor != null){
                Editor editor = PushUtils.getGCMPreferences(c).edit();
                editor.putString(DEFAULT_NOTIFICATION, notificationClass.getName());
                editor.commit();
            }else{
                throw new SecurityException("Class "+notificationClass+" must have a constructor with JSONObject parameter");
            }
        }catch(NoSuchMethodException nsme){
            throw new SecurityException("Class "+notificationClass+" must have a constructor with JSONObject parameter");
        }
	}

	public static void unregisterDefaultNotification(Context c) {

		Editor editor = PushUtils.getGCMPreferences(c).edit();
		editor.remove(DEFAULT_NOTIFICATION);
		editor.commit();
	}

	public static EasypushNotification getDefaultNotification(Context c, JSONObject message) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		String defaultNotificationClass = preferences.getString(
				DEFAULT_NOTIFICATION, "");
		if (!TextUtils.isEmpty(defaultNotificationClass)) {
			try {

                Object myClass = Class.forName(defaultNotificationClass).getDeclaredConstructor(JSONObject.class)
						.newInstance(message);
				if (myClass instanceof EasypushNotification) {
					return (EasypushNotification) myClass;
				}
			} catch (Throwable t) {
			}
		}
		return null;
	}

	public static void setLaunchIntentOnNotification(Context c, Intent i) {
		Editor editor = PushUtils.getGCMPreferences(c).edit();
		editor.putString(LAUNCH_INTENT, i.getComponent().getClassName());
		editor.commit();
	}

	public static Intent getLaunchIntentOnNotification(Context c) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		String launchIntentClass = preferences.getString(LAUNCH_INTENT, "");
		if (!TextUtils.isEmpty(launchIntentClass)) {
			try {
				return new Intent(c, Class.forName(launchIntentClass));
			} catch (ClassNotFoundException e) {
			}
		}
		return null;
	}

	public static void addOnBeforeLaunchNotification(Context c,
			Class<? extends OnBeforeLaunchNotification> onBeforeSend) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		HashSet<String> set = new HashSet<String>(Arrays.asList(preferences
				.getString(BEFORE_SEND, "").split(",")));
		if (!set.contains(onBeforeSend.getName())) {
			set.add(onBeforeSend.getName());
		}
		Editor editor = preferences.edit();
		editor.putString(BEFORE_SEND, TextUtils.join(",", set.toArray()));
		editor.commit();
	}

	public static void removeOnBeforeLaunchNotification(Context c,
			Class<? extends OnBeforeLaunchNotification> onBeforeSend) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		HashSet<String> set = new HashSet<String>(Arrays.asList(preferences
				.getString(BEFORE_SEND, "").split(",")));
		if (set.contains(onBeforeSend.getName())) {
			set.remove(onBeforeSend.getName());
		}
		Editor editor = preferences.edit();
		editor.putString(BEFORE_SEND, TextUtils.join(",", set.toArray()));
		editor.commit();

	}

	public static void preventAllOnBeforeLaunchNotification(Context c,
			NotificationCompat.Builder notificationBuilder, JSONObject jsonMessage) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		HashSet<String> set = new HashSet<String>(Arrays.asList(preferences
				.getString(BEFORE_SEND, "").split(",")));
		for (String className : set) {
			try {
				Object myClass = Class.forName(className).newInstance();
				if (myClass instanceof OnBeforeLaunchNotification) {
					((OnBeforeLaunchNotification) myClass)
							.beforeLaunchNotification(c, notificationBuilder, jsonMessage);
				}
			} catch (Throwable t) {
			}

		}

	}

	public static void addOnAfterLaunchNotification(Context c,
			Class<? extends OnAfterLaunchNotification> onAfterSend) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		HashSet<String> set = new HashSet<String>(Arrays.asList(preferences
				.getString(AFTER_SEND, "").split(",")));
		if (!set.contains(onAfterSend.getName())) {
			set.add(onAfterSend.getName());
		}
		Editor editor = preferences.edit();
		editor.putString(AFTER_SEND, TextUtils.join(",", set.toArray()));
		editor.commit();

	}

	public static void removeOnAfterLaunchNotification(Context c,
			Class<? extends OnAfterLaunchNotification> onAfterSend) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		HashSet<String> set = new HashSet<String>(Arrays.asList(preferences
				.getString(AFTER_SEND, "").split(",")));
		if (set.contains(onAfterSend.getName())) {
			set.remove(onAfterSend.getName());
		}
		Editor editor = preferences.edit();
		editor.putString(AFTER_SEND, TextUtils.join(",", set.toArray()));
		editor.commit();

	}

	public static void preventAllOnAfterLaunchNotification(Context c,
			Notification notification, JSONObject jsonMessage) {
		SharedPreferences preferences = PushUtils.getGCMPreferences(c);
		HashSet<String> set = new HashSet<String>(Arrays.asList(preferences
				.getString(AFTER_SEND, "").split(",")));
		for (String className : set) {
			try {
				Object myClass = Class.forName(className).newInstance();
				if (myClass instanceof OnAfterLaunchNotification) {
					((OnAfterLaunchNotification) myClass)
							.afterLaunchNotification(c, notification, jsonMessage);
				}
			} catch (Throwable t) {
			}

		}

	}

}
