package eu.easypush.pushlibrary.services;

import org.json.JSONObject;

import android.app.IntentService;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.util.Log;

import com.google.android.gms.gcm.GoogleCloudMessaging;

import eu.easypush.pushlibrary.constants.EasyPushConstants;
import eu.easypush.pushlibrary.notifications.SimpleNotification;
import eu.easypush.pushlibrary.utils.NotificationUtils;
import eu.easypush.pushlibrary.utils.PushConstants;
import eu.easypush.pushlibrary.utils.PushUtils;
import eu.easypush.pushlibrary.notifications.EasypushNotification;
import eu.easypush.pushlibrary.notifications.NotificationFactory;

public class GCMIntentService extends IntentService implements PushConstants {

	public static final int NOTIFICATION_ID = 1;
	private NotificationManager mNotificationManager;
	NotificationCompat.Builder builder;

	public GCMIntentService() {
		super("GcmIntentService");
	}

	@Override
	protected void onHandleIntent(Intent intent) {
		Bundle extras = intent.getExtras();
		GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance(this);
		// The getMessageType() intent parameter must be the intent you received
		// in your BroadcastReceiver.
		String messageType = gcm.getMessageType(intent);

		if (!extras.isEmpty()) { // has effect of unparcelling Bundle
			/*
			 * Filter messages based on message type. Since it is likely that
			 * GCM will be extended in the future with new message types, just
			 * ignore any message types you're not interested in, or that you
			 * don't recognize.
			 */
			if (GoogleCloudMessaging.MESSAGE_TYPE_SEND_ERROR
					.equals(messageType)) {
			} else if (GoogleCloudMessaging.MESSAGE_TYPE_DELETED
					.equals(messageType)) {
				// If it's a regular GCM message, do some work.
			} else if (GoogleCloudMessaging.MESSAGE_TYPE_MESSAGE
					.equals(messageType)) {

				if (PushUtils.isGlobalPushEnabled(this)
						&& PushUtils.isApplicationPushEnabled(this)) {

					try {
						JSONObject object = new JSONObject(
								extras.getString("message"));
						if (object.optString(
								EasyPushConstants.EZ_MESSAGE_RECEIVED_ID, null) != null) {
							PushUtils
									.setMessageReceived(
											this,
											object.getString(EasyPushConstants.EZ_MESSAGE_RECEIVED_ID));
						}

                        EasypushNotification easypushNotification = NotificationUtils
                                .getDefaultNotification(this, object);
                        if (easypushNotification == null) {
                            if (object.optString(EasyPushConstants.EZ_MESSAGE_TYPE,
                                    null) != null) {
                                easypushNotification = NotificationFactory
                                        .getNotification(object
                                                .getString(EasyPushConstants.EZ_MESSAGE_TYPE), object);
                            }else {
                                easypushNotification = new SimpleNotification(object);
                            }
                        }
                        final EasypushNotification notificationToLaunch = easypushNotification;
                        AsyncTask<Void, Void, Void> execute = new AsyncTask<Void, Void, Void>() {

                            @Override
                            protected Void doInBackground(Void... voids) {

                                String applicationName = getApplicationName(GCMIntentService.this);
                                NotificationCompat.Builder builder = notificationToLaunch.createNotification(GCMIntentService.this, applicationName);
                                notificationToLaunch.launchNotification(GCMIntentService.this, applicationName.hashCode(), builder);

                                return null;
                            }
                        };
                        execute.execute();

					} catch (Throwable e) {
						e.printStackTrace();
					}
					Log.i(TAG, "Received: " + extras.toString());

				}

			}
		}
	}

	// @TargetApi(Build.VERSION_CODES.HONEYCOMB)
	// @Override
	// protected final void onMessage(Context context, Intent intent) {
	// Log.d(GCMBaseIntentService.TAG, "OnMessage");
	//
	// JSONObject json;
	// try {
	// json = new JSONObject(intent.getStringExtra("message"));
	// treatPushMessage(context, json);
	// } catch (JSONException e) {
	// }
	//
	// }

	private String getApplicationName(Context context) {
		final PackageManager pm = context.getPackageManager();
		ApplicationInfo ai;
		try {
			ai = pm.getApplicationInfo(this.getPackageName(), 0);
		} catch (final NameNotFoundException e) {
			ai = null;
		}
		return (String) (ai != null ? pm.getApplicationLabel(ai) : "(unknown)");

	}
}
