package eu.easypush.pushlibrary.notifications;

import java.util.Random;

import org.json.JSONObject;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.NotificationCompat;
import eu.easypush.pushlibrary.utils.PushUtils;

public class SimpleNotification extends
		eu.easypush.pushlibrary.notifications.EasypushNotification {

    public SimpleNotification(JSONObject _jsonMessage){
        super(_jsonMessage);
    }


    @Override
	public NotificationCompat.Builder createNotification(Context context,
			String titleOfApplication) {
		int icon = context.getApplicationInfo().icon;
		long when = System.currentTimeMillis();

		String alert = jsonMessage.optString("alert", null);

		NotificationCompat.Builder builder = new NotificationCompat.Builder(
				context);
		builder.setTicker(alert);
		builder.setAutoCancel(true);
		builder.setSmallIcon(icon);
		builder.setContentTitle(titleOfApplication);
		builder.setContentText(alert);
		builder.setWhen(when + 2000);
		builder.setSound(PushUtils.getPushSoundUri(context));
		builder.setDefaults(Notification.DEFAULT_LIGHTS
				| Notification.DEFAULT_VIBRATE);
		NotificationCompat.BigTextStyle bts = new NotificationCompat.BigTextStyle();
		bts.bigText(alert);
		builder.setStyle(bts);

		Intent i = getIntentToLaunch(context, jsonMessage);

		PendingIntent contentIntent = PendingIntent.getActivity(context,
				new Random().nextInt(), i, 0);
		builder.setContentIntent(contentIntent);

        return builder;
	}
}
