package eu.easypush.pushlibrary.notifications;

import org.json.JSONObject;

import java.util.HashMap;

public class NotificationFactory {
	public static final HashMap<String, String> notificationsByType = new HashMap<String, String>() {
		{
			put("simple", SimpleNotification.class.getName());
			put("expandablepicture", ExpandablePictureNotification.class.getName());
		}
	};

	public static EasypushNotification getNotification(String type, JSONObject message) {
		String className = notificationsByType.get(type);
        if (className == null){
            return new SimpleNotification(message);
        }
        try {
            Object myClass = Class.forName(className).getDeclaredConstructor(JSONObject.class)
                    .newInstance(message);
            if (myClass instanceof EasypushNotification) {
                return (EasypushNotification) myClass;
            }
        } catch (Throwable t) {
        }
        return new SimpleNotification(message);


    }
}
