/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.twitterstream.vectorize;

import eu.dicodeproject.analysis.lucene.IterableAnalyzer;
import eu.dicodeproject.analysis.util.Language;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class Vectorizer {
    private static final Logger log = LoggerFactory.getLogger(Vectorizer.class);
    private Language language;
    private Map<String, Analyzer> analyzers;
    private StandardAnalyzer standardAnalyzer;

    public Map<String, Integer> createVector(String text) throws IOException {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        for (String token : new IterableAnalyzer(this.getAnalyzer(), text)) {
            Integer count = (Integer)m.get(token);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            m.put(token, count);
        }
        return m;
    }

    private Analyzer getAnalyzer() {
        Analyzer analyzer = null;
        if (this.analyzers != null && this.language != null) {
            analyzer = this.analyzers.get(this.language.getCode());
        }
        if (analyzer == null) {
            log.info("no analyzer for language '" + this.language + "'; using StandardAnalyzer");
            analyzer = this.standardAnalyzer;
        }
        return analyzer;
    }

    public void setAnalyzers(Map<String, Analyzer> analyzers) {
        this.analyzers = analyzers;
    }

    @Required
    public void setStandardAnalyzer(StandardAnalyzer standardAnalyzer) {
        this.standardAnalyzer = standardAnalyzer;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }
}

