/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.twitterstream.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TwitterHarvesterCFGBuilder {
    private static final Logger log = LoggerFactory.getLogger(TwitterHarvesterCFGBuilder.class);
    public static final String DEFAULT_PROPERTIES_FILENAME = "eu.dicode.twitterharvester.properties";

    static Configuration buildConfiguration(String[] args) {
        PropertiesConfiguration cmdLineCFG;
        block10: {
            OptionBuilder.withArgName((String)"p");
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)"properties");
            OptionBuilder.withDescription((String)"Full qualified name of twitter harvester's property file.");
            Option propertiesFileOption = OptionBuilder.create((String)"p");
            OptionBuilder.withDescription((String)"Print usage message and exit.");
            Option helpOption = OptionBuilder.create((String)"help");
            Options options = new Options();
            options.addOption(propertiesFileOption);
            options.addOption(helpOption);
            GnuParser parser = new GnuParser();
            cmdLineCFG = null;
            if (args != null) {
                HelpFormatter formatter;
                try {
                    CommandLine line = parser.parse(options, args);
                    if (line.hasOption("help")) {
                        formatter = new HelpFormatter();
                        formatter.printHelp("command", options);
                        System.exit(1);
                    }
                    if (!line.hasOption("p")) break block10;
                    String propFilename = line.getOptionValue("p");
                    if (propFilename == null) {
                        throw new ParseException("Full qualified name of twitter harvester's property file must not be null.");
                    }
                    try {
                        cmdLineCFG = new PropertiesConfiguration(propFilename);
                    }
                    catch (ConfigurationException e) {
                        throw new ParseException(e.getMessage());
                    }
                }
                catch (ParseException e) {
                    log.error("Parsing failed. Details: " + e.getMessage(), (Throwable)e);
                    formatter = new HelpFormatter();
                    formatter.printHelp("command", options);
                    System.exit(1);
                }
            }
        }
        CompositeConfiguration cc = null;
        try {
            if (cmdLineCFG == null) {
                return new PropertiesConfiguration(DEFAULT_PROPERTIES_FILENAME);
            }
            cc = new CompositeConfiguration();
            cc.addConfiguration(cmdLineCFG);
            cc.addConfiguration((Configuration)new PropertiesConfiguration(DEFAULT_PROPERTIES_FILENAME));
        }
        catch (ConfigurationException e) {
            log.error("Unable to load configuration. Details: " + e.getMessage(), (Throwable)e);
            System.exit(2);
        }
        return cc;
    }
}

