/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.twitterstream.daemonize;

import eu.dicodeproject.twitterstream.StreamingBroker;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericXmlApplicationContext;

public class TwitterDaemon {
    private static Logger LOG = LoggerFactory.getLogger(TwitterDaemon.class);
    private StreamingBroker tweetBroker;
    private ConfigurableApplicationContext context = null;

    public void init() throws IOException {
        LOG.info("Initializing Twitter Broker daemon. Make sure to have started HBase before seeing this message.");
        this.context = new GenericXmlApplicationContext(new String[]{"eu.dicodeproject.twitterharvester.context.xml"});
        this.tweetBroker = (StreamingBroker)this.context.getBean(StreamingBroker.class);
        LOG.info("Service init done.");
    }

    public void start() {
        LOG.info("Starting tweet broker.");
        this.tweetBroker.start();
        LOG.info("Service started.");
    }

    public void stop() {
        LOG.info("Stopping tweet broker.");
        this.context.stop();
        LOG.info("Service stopped.");
    }

    public void destroy() {
        LOG.info("Stopping tweet broker.");
        this.context.stop();
        LOG.info("Service stopped.");
    }

    StreamingBroker getTwitterBroker() {
        return this.tweetBroker;
    }
}

