/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.wordcount;

import eu.dicodeproject.analysis.lucene.CleansingAnalyzer;
import eu.dicodeproject.analysis.lucene.IterableAnalyzer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.lucene.analysis.Analyzer;

public class WordCountMapper
extends TableMapper<Text, IntWritable> {
    private String dateWordSeparator = "_";
    private String targetWordsConfKey = "targetWords";
    private Text term = new Text();
    private static IntWritable one = new IntWritable(1);
    private Calendar cal = Calendar.getInstance();
    private Analyzer cleansingAnalyzer = new CleansingAnalyzer();
    private byte[] creationDateBytes = Bytes.toBytes((String)"creationDate");

    protected void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException, InterruptedException {
        String tw = context.getConfiguration().get(this.targetWordsConfKey);
        HashSet<String> targetWords = new HashSet<String>();
        for (String t : new IterableAnalyzer(this.cleansingAnalyzer, tw)) {
            targetWords.add(t);
        }
        String date = "";
        LinkedList<String> foundWords = new LinkedList<String>();
        for (KeyValue keyValue : values.list()) {
            if (this.isCreationDateColumn(keyValue)) {
                date = this.getDate(keyValue);
                continue;
            }
            this.addWords(targetWords, keyValue, foundWords);
        }
        for (String fw : foundWords) {
            this.term.set(date + this.dateWordSeparator + fw);
            context.write((Object)this.term, (Object)one);
        }
    }

    private boolean isCreationDateColumn(KeyValue kv) {
        return Arrays.equals(kv.getQualifier(), this.creationDateBytes);
    }

    private String getDate(KeyValue kv) {
        String day;
        long creationDateLong = Bytes.toLong((byte[])kv.getValue());
        this.cal.setTimeInMillis(creationDateLong);
        String year = String.valueOf(this.cal.get(1));
        String month = String.valueOf(this.cal.get(2) + 1);
        if (month.length() == 1) {
            month = "0" + month;
        }
        if ((day = String.valueOf(this.cal.get(5))).length() == 1) {
            day = "0" + day;
        }
        return year + "-" + month + "-" + day;
    }

    private void addWords(Set<String> targetWords, KeyValue kv, List<String> foundWords) throws IOException {
        for (String t : new IterableAnalyzer(this.cleansingAnalyzer, new String(kv.getValue()))) {
            if (!targetWords.contains(t)) continue;
            foundWords.add(t);
        }
    }
}

