/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.wordcount;

import eu.dicodeproject.analysis.wordcount.WordCountMapper;
import eu.dicodeproject.analysis.wordcount.WordCountReducer;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;

public final class WordCountDriver
extends AbstractJob {
    private String targetWordsConfKey = "targetWords";

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new WordCountDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, InterruptedException, IOException {
        this.addOption("inputTable", "i", "The hbase table holding our data.", "thtweets");
        this.addOption("family", "f", "The column family holding our data.", "d");
        this.addOption("textColumn", "c", "The column qualifier holding our text.", "text");
        this.addOption("timeColumn", "d", "The column qualifier holding our creationDate.", "creationDate");
        this.addOption("outputTable", "t", "The resulting hbase table in which the histogram is written.", "thtweets-wordCounts");
        this.addOption("targetWords", "w", "The comma-separated targetWords that should be searched for.", "Berlin,Paris,Athens");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        String inputTable = (String)argMap.get("--inputTable");
        String dataFamily = (String)argMap.get("--family");
        String textColumn = (String)argMap.get("--textColumn");
        String timeColumn = (String)argMap.get("--timeColumn");
        String outputTable = (String)argMap.get("--outputTable");
        String targetWords = (String)argMap.get("--targetWords");
        this.checkWords(targetWords);
        boolean success = this.generateWordHistogramData(inputTable, dataFamily, textColumn, targetWords, timeColumn, outputTable);
        return success ? 0 : 1;
    }

    private boolean generateWordHistogramData(String inputTable, String dataFamily, String textColumn, String targetWords, String timeColumn, String outputTable) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = HBaseConfiguration.create();
        conf.set(this.targetWordsConfKey, targetWords.replace(",", " "));
        Job job = new Job(conf, "WordCountDriver::GenerateWordCountData");
        job.setJarByClass(WordCountDriver.class);
        Scan scan = new Scan();
        scan.addColumn(Bytes.toBytes((String)dataFamily), Bytes.toBytes((String)textColumn));
        scan.addColumn(Bytes.toBytes((String)dataFamily), Bytes.toBytes((String)timeColumn));
        scan.setMaxVersions(1);
        TableMapReduceUtil.initTableMapperJob((String)inputTable, (Scan)scan, WordCountMapper.class, Text.class, IntWritable.class, (Job)job);
        TableMapReduceUtil.initTableReducerJob((String)outputTable, WordCountReducer.class, (Job)job);
        job.setNumReduceTasks(10);
        return job.waitForCompletion(true);
    }

    private void checkWords(String words) {
        for (String word : words.split(",")) {
            if (!word.trim().contains(" ")) continue;
            throw new IllegalArgumentException("only single words allowed as target; got " + word);
        }
    }
}

