/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.util;

import java.util.HashMap;
import java.util.Map;

public enum Language {
    GERMAN("de"),
    ENGLISH("en"),
    SPANISH("es"),
    FRENCH("fr"),
    INDONESIAN("id"),
    ITALIAN("it"),
    DUTCH("nl"),
    PORTUGUESE("pt"),
    RUSSIAN("ru"),
    TURKISH("tr");

    private String code;
    private static final Map<String, Language> lookup;

    private Language(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static Language fromCode(String code) {
        return lookup.get(code);
    }

    static {
        lookup = new HashMap<String, Language>();
        for (Language d : Language.values()) {
            lookup.put(d.code, d);
        }
    }
}

