/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.twitter;

import eu.dicodeproject.analysis.twitter.SchemaUpdaterMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;

public class SchemaUpdaterDriver
extends AbstractJob {
    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new SchemaUpdaterDriver(), (String[])args);
    }

    public int run(String[] args) throws ClassNotFoundException, InterruptedException, IOException {
        this.addOption("sourcetable", "s", "The hbase table holding our data.", "twitterstream");
        this.addOption("sourcetextfamily", "stf", "The source table's column family holding our data.", "textFamily");
        this.addOption("sourcemetafamily", "smf", "The source table's column family holding our data.", "metaFamily");
        this.addOption("table", "t", "The hbase table holding our data.");
        this.addOption("family", "f", "The column family holding our data.", "d");
        Map argMap = this.parseArguments(args);
        if (argMap == null) {
            return 1;
        }
        String sourceTable = (String)argMap.get("--sourcetable");
        String sourceTextFamily = (String)argMap.get("--sourcetextfamily");
        String sourceMetaFamily = (String)argMap.get("--sourcemetafamily");
        String table = (String)argMap.get("--table");
        if (StringUtils.isBlank((String)table)) {
            return 2;
        }
        String family = (String)argMap.get("--family");
        Configuration cfg = HBaseConfiguration.create();
        cfg.set("sourceTextFamily", sourceTextFamily);
        cfg.set("sourceMetaFamily", sourceMetaFamily);
        cfg.set("table", table);
        cfg.set("family", family);
        Job job = new Job(cfg);
        job.setJarByClass(SchemaUpdaterDriver.class);
        Scan scan = new Scan();
        TableMapReduceUtil.initTableMapperJob((String)sourceTable, (Scan)scan, SchemaUpdaterMapper.class, NullWritable.class, NullWritable.class, (Job)job);
        job.setJobName("SchemaUpdater");
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(Reducer.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(NullWritable.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        job.waitForCompletion(true);
        return 0;
    }
}

