/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.lucene;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class IterableAnalyzer
implements Iterable<String>,
Iterator<String> {
    private String buffer;
    private TokenStream tokenStream;
    private CharTermAttribute charTermAttribute;

    public IterableAnalyzer(Analyzer analyzer, String text) throws IOException {
        StringReader textReader = new StringReader(text);
        this.tokenStream = analyzer.tokenStream(null, (Reader)textReader);
        this.charTermAttribute = (CharTermAttribute)this.tokenStream.getAttribute(CharTermAttribute.class);
        this.updateBuffer();
    }

    private void updateBuffer() throws IOException {
        this.buffer = this.tokenStream.incrementToken() ? this.charTermAttribute.toString() : null;
    }

    @Override
    public boolean hasNext() {
        return this.buffer != null;
    }

    @Override
    public String next() {
        String oldBuffer = this.buffer;
        try {
            this.updateBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return oldBuffer;
    }

    @Override
    public void remove() {
        throw new NotImplementedException();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

