/*
 * Decompiled with CFR 0.152.
 */
package eu.dicodeproject.analysis.lucene;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Version;

public final class CleansingAnalyzer
extends Analyzer {
    private final int lowerBound;
    private final boolean enablePositionIncrement;

    public CleansingAnalyzer() {
        this(2, false);
    }

    public CleansingAnalyzer(int lowerBound, boolean enablePositionIncrement) {
        this.lowerBound = lowerBound;
        this.enablePositionIncrement = enablePositionIncrement;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new CleansingFilter((TokenStream)new StopFilter(false, (TokenStream)new LowerCaseFilter((TokenStream)new StandardFilter((TokenStream)new StandardTokenizer(Version.LUCENE_30, reader))), StopAnalyzer.ENGLISH_STOP_WORDS_SET, true), this.lowerBound, this.enablePositionIncrement);
    }

    private static class CleansingFilter
    extends TokenFilter {
        private final int lowerBound;
        private final boolean enablePositionIncrement;
        private final Pattern digitPattern = Pattern.compile("[0-9]*");
        private final TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.digitPattern == null ? 0 : this.digitPattern.hashCode());
            result = 31 * result + (this.enablePositionIncrement ? 1231 : 1237);
            result = 31 * result + this.lowerBound;
            result = 31 * result + (this.posIncrAtt == null ? 0 : this.posIncrAtt.hashCode());
            result = 31 * result + (this.termAtt == null ? 0 : this.termAtt.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof CleansingFilter)) {
                return false;
            }
            CleansingFilter other = (CleansingFilter)((Object)obj);
            if (this.digitPattern == null ? other.digitPattern != null : !this.digitPattern.equals(other.digitPattern)) {
                return false;
            }
            if (this.enablePositionIncrement != other.enablePositionIncrement) {
                return false;
            }
            if (this.lowerBound != other.lowerBound) {
                return false;
            }
            if (this.posIncrAtt == null ? other.posIncrAtt != null : !this.posIncrAtt.equals(other.posIncrAtt)) {
                return false;
            }
            return !(this.termAtt == null ? other.termAtt != null : !this.termAtt.equals(other.termAtt));
        }

        protected CleansingFilter(TokenStream input, int lowerBound, boolean enablePositionIncrement) {
            super(input);
            this.lowerBound = lowerBound;
            this.enablePositionIncrement = enablePositionIncrement;
        }

        protected CleansingFilter(TokenStream input) {
            this(input, 2, false);
        }

        public boolean incrementToken() throws IOException {
            int skippedPositions = 0;
            while (this.input.incrementToken()) {
                String token = new String(this.termAtt.termBuffer(), 0, this.termAtt.termLength());
                if (!this.isTooShort(token) && !this.isDigitOnly(token)) {
                    if (this.enablePositionIncrement) {
                        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + skippedPositions);
                    }
                    return true;
                }
                skippedPositions += this.posIncrAtt.getPositionIncrement();
            }
            return false;
        }

        private boolean isTooShort(String token) {
            return token.length() <= this.lowerBound;
        }

        private boolean isDigitOnly(String token) {
            return this.digitPattern.matcher(token).matches();
        }
    }
}

